/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats.entropy;

import datafu.pig.stats.entropy.EntropyEstimator;
import java.io.IOException;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Entropy
extends AccumulatorEvalFunc<Double> {
    private Tuple x;
    private long cx;
    private int lastCmp;
    private EntropyEstimator estimator;

    public Entropy() throws ExecException {
        this("empirical");
    }

    public Entropy(String type) throws ExecException {
        this(type, "log");
    }

    public Entropy(String type, String base) throws ExecException {
        try {
            this.estimator = EntropyEstimator.createEstimator(type, base);
        }
        catch (IllegalArgumentException ex) {
            throw new ExecException(String.format("Fail to initialize StreamingEntropy with entropy estimator of type (%s), base: (%s), exception: (%s)", type, base, ex));
        }
        this.cleanup();
    }

    public void accumulate(Tuple input) throws IOException {
        for (Tuple t : (DataBag)input.get(0)) {
            if (this.x != null) {
                int cmp = t.compareTo((Object)this.x);
                if (cmp < 0 && this.lastCmp > 0 || cmp > 0 && this.lastCmp < 0) {
                    throw new ExecException("Out of order! previous tuple: " + this.x + ", present tuple: " + t + ", comparsion: " + cmp + ", previous comparsion: " + this.lastCmp);
                }
                if (cmp != 0) {
                    this.estimator.accumulate(this.cx);
                    this.cx = 0L;
                    this.lastCmp = cmp;
                }
            }
            this.x = t;
            ++this.cx;
        }
    }

    public Double getValue() {
        try {
            this.estimator.accumulate(this.cx);
        }
        catch (ExecException ex) {
            throw new RuntimeException("Error while accumulating sample frequency: " + (Object)((Object)ex));
        }
        return this.estimator.getEntropy();
    }

    public void cleanup() {
        this.x = null;
        this.cx = 0L;
        this.lastCmp = 0;
        this.estimator.reset();
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 25));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

