/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats.entropy;

import datafu.pig.stats.entropy.ChaoShenEntropyEstimator;
import datafu.pig.stats.entropy.EmpiricalEntropyEstimator;
import datafu.pig.stats.entropy.EntropyUtil;
import org.apache.pig.backend.executionengine.ExecException;

public abstract class EntropyEstimator {
    public static final String EMPIRICAL_ESTIMATOR = "empirical";
    public static final String CHAOSHEN_ESTIMATOR = "chaosh";
    protected String base;

    protected EntropyEstimator(String base) throws IllegalArgumentException {
        if (!EntropyUtil.isValidLogBase(base)) {
            throw new IllegalArgumentException("Invalid input logarithm base. Please refer to StreamingEntropy's javadoc for supported logarithm base");
        }
        this.base = base;
    }

    public static EntropyEstimator createEstimator(String type, String base) throws IllegalArgumentException {
        if (EMPIRICAL_ESTIMATOR.equalsIgnoreCase(type)) {
            return new EmpiricalEntropyEstimator(base);
        }
        if (CHAOSHEN_ESTIMATOR.equalsIgnoreCase(type)) {
            return new ChaoShenEntropyEstimator(base);
        }
        throw new IllegalArgumentException("invalid input entropy estimator type. Please refer to StreamingEntropy's javadoc for the supported estimator types");
    }

    public abstract void accumulate(long var1) throws ExecException;

    public abstract double getEntropy();

    public abstract void reset();
}

