/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.urls;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class URLInfo
extends EvalFunc<Tuple> {
    private static final int TUPLE_ELEMENTS = 6;
    private static Pattern pDomain = Pattern.compile(".*?([^.]+\\.[^.]+)");

    private static String getDomain(URL url) {
        Matcher m = pDomain.matcher(url.getHost());
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    private static String getHost(URL url) {
        return url.getHost();
    }

    private static String getProtocol(URL url) {
        return url.getProtocol();
    }

    private static String getPath(URL url) {
        return url.getPath();
    }

    private static Integer getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            return null;
        }
        return port;
    }

    private static Map<String, String> getQueryParams(URL url) {
        String queryString = url.getQuery();
        if (queryString == null) {
            return null;
        }
        String[] qFields = queryString.split("&");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (int i = 0; i < qFields.length; ++i) {
            String[] kv = qFields[i].split("=");
            if (kv.length != 2 || queryParams.containsKey(kv[0])) continue;
            queryParams.put(kv[0], kv[1]);
        }
        return queryParams;
    }

    public Tuple exec(Tuple tuple) throws IOException {
        URL url;
        Tuple output = TupleFactory.getInstance().newTuple(6);
        for (int i = 0; i < 6; ++i) {
            output.set(i, null);
        }
        if (tuple == null) {
            return output;
        }
        String input = tuple.get(0) == null ? "" : tuple.get(0).toString().trim();
        try {
            url = new URL(input);
        }
        catch (MalformedURLException e) {
            return null;
        }
        output.set(0, (Object)URLInfo.getDomain(url));
        output.set(1, (Object)URLInfo.getHost(url));
        output.set(2, (Object)URLInfo.getProtocol(url));
        output.set(3, (Object)URLInfo.getPath(url));
        output.set(4, (Object)URLInfo.getPort(url));
        output.set(5, URLInfo.getQueryParams(url));
        return output;
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema("domain", 55));
            tupleSchema.add(new Schema.FieldSchema("host", 55));
            tupleSchema.add(new Schema.FieldSchema("protocol", 55));
            tupleSchema.add(new Schema.FieldSchema("path", 55));
            tupleSchema.add(new Schema.FieldSchema("port", 10));
            tupleSchema.add(new Schema.FieldSchema("queryParams", 100));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
        }
        catch (Exception e) {
            System.out.println("exception in URLInfo outputSchema: '" + e + "'; returning null schema.\n");
            return null;
        }
    }
}

