/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.util;

import datafu.pig.util.ContextualEvalFunc;
import datafu.pig.util.FieldNotFound;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class AliasableEvalFunc<T>
extends ContextualEvalFunc<T> {
    private static final String ALIAS_MAP_PROPERTY = "aliasMap";
    private Map<String, Integer> aliasToPosition = null;

    @Override
    public Schema outputSchema(Schema input) {
        this.storeFieldAliases(input);
        return this.getOutputSchema(input);
    }

    public abstract Schema getOutputSchema(Schema var1);

    private Map<String, Integer> getAliasMap() {
        if (this.aliasToPosition == null) {
            if (this.getInputSchema() == null) {
                this.aliasToPosition = (Map)this.getInstanceProperties().get(ALIAS_MAP_PROPERTY);
            } else {
                HashMap<String, Integer> aliasMap = new HashMap<String, Integer>();
                this.constructFieldAliases(aliasMap, this.getInputSchema(), null);
                this.log.debug((Object)("In instance: " + this.getInstanceName() + ", creating alias map: " + aliasMap));
                this.aliasToPosition = aliasMap;
            }
        }
        return this.aliasToPosition;
    }

    private void setAliasMap(Map<String, Integer> aliases) {
        this.getInstanceProperties().put(ALIAS_MAP_PROPERTY, aliases);
    }

    private void storeFieldAliases(Schema tupleSchema) {
        HashMap<String, Integer> aliases = new HashMap<String, Integer>();
        this.constructFieldAliases(aliases, tupleSchema, null);
        this.log.debug((Object)("In instance: " + this.getInstanceName() + ", stored alias map: " + aliases));
        this.setAliasMap(aliases);
    }

    private void constructFieldAliases(Map<String, Integer> aliases, Schema tupleSchema, String prefix) {
        int position = 0;
        for (Schema.FieldSchema field : tupleSchema.getFields()) {
            String alias = this.getPrefixedAliasName(prefix, field.alias);
            if (field.alias != null && !field.alias.equals("null")) {
                aliases.put(alias, position);
                this.log.debug((Object)("In instance: " + this.getInstanceName() + ", stored alias " + alias + " as position " + position));
            }
            if (field.schema != null) {
                this.constructFieldAliases(aliases, field.schema, alias);
            }
            ++position;
        }
    }

    public String getPrefixedAliasName(String prefix, String alias) {
        if (alias == null || alias.equals("null")) {
            if (prefix == null) {
                return "";
            }
            return prefix;
        }
        return (prefix == null || prefix.equals("null") || prefix.trim().equals("") ? "" : prefix + ".") + alias;
    }

    public Map<String, Integer> getFieldAliases() {
        Map<String, Integer> aliases = this.getAliasMap();
        if (aliases == null) {
            this.log.error((Object)("Class: " + ((Object)((Object)this)).getClass()));
            this.log.error((Object)("Instance name: " + this.getInstanceName()));
            this.log.error((Object)("Properties: " + this.getContextProperties()));
            throw new RuntimeException("Could not retrieve aliases from properties using aliasMap");
        }
        return aliases;
    }

    public Integer getPosition(String alias) {
        if (this.aliasToPosition == null) {
            this.aliasToPosition = this.getFieldAliases();
        }
        return this.aliasToPosition.get(alias);
    }

    public Integer getPosition(String prefix, String alias) {
        return this.getPosition(this.getPrefixedAliasName(prefix, alias));
    }

    public Integer getInteger(Tuple tuple, String alias) throws ExecException {
        return this.getInteger(tuple, alias, null);
    }

    public Integer getInteger(Tuple tuple, String alias, Integer defaultValue) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        Number number = (Number)tuple.get(i.intValue());
        if (number == null) {
            return defaultValue;
        }
        return number.intValue();
    }

    public Long getLong(Tuple tuple, String alias) throws ExecException {
        return this.getLong(tuple, alias, null);
    }

    public Long getLong(Tuple tuple, String alias, Long defaultValue) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        Number number = (Number)tuple.get(i.intValue());
        if (number == null) {
            return defaultValue;
        }
        return number.longValue();
    }

    public Float getFloat(Tuple tuple, String alias) throws ExecException {
        return this.getFloat(tuple, alias, null);
    }

    public Float getFloat(Tuple tuple, String alias, Float defaultValue) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        Number number = (Number)tuple.get(i.intValue());
        if (number == null) {
            return defaultValue;
        }
        return Float.valueOf(number.floatValue());
    }

    public Double getDouble(Tuple tuple, String alias) throws ExecException {
        return this.getDouble(tuple, alias, null);
    }

    public Double getDouble(Tuple tuple, String alias, Double defaultValue) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        Number number = (Number)tuple.get(i.intValue());
        if (number == null) {
            return defaultValue;
        }
        return number.doubleValue();
    }

    public String getString(Tuple tuple, String alias) throws ExecException {
        return this.getString(tuple, alias, null);
    }

    public String getString(Tuple tuple, String alias, String defaultValue) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        String s = (String)tuple.get(i.intValue());
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public Boolean getBoolean(Tuple tuple, String alias) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        return (Boolean)tuple.get(i.intValue());
    }

    public DataBag getBag(Tuple tuple, String alias) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        return (DataBag)tuple.get(i.intValue());
    }

    public Object getObject(Tuple tuple, String alias) throws ExecException {
        Integer i = this.getPosition(alias);
        if (i == null) {
            throw new FieldNotFound("Attempt to reference unknown alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        if (i >= tuple.size()) {
            throw new FieldNotFound("Attempt to reference outside of tuple for alias: " + alias + "\n Instance Properties: " + this.getInstanceProperties());
        }
        return tuple.get(i.intValue());
    }
}

