/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.util;

import datafu.pig.util.AliasableEvalFunc;
import datafu.pig.util.DataFuException;
import java.io.IOException;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Coalesce
extends AliasableEvalFunc<Object> {
    private boolean strict;
    private static String STRICT_OPTION = "strict";
    private static String LAZY_OPTION = "lazy";

    public Coalesce() {
        this.strict = true;
    }

    public Coalesce(String option) {
        if (option.equals(STRICT_OPTION)) {
            this.strict = true;
        } else if (option.equals(LAZY_OPTION)) {
            this.strict = false;
        } else {
            throw new IllegalArgumentException("Unexpected option: " + option);
        }
    }

    public Object exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        Byte type = (Byte)this.getInstanceProperties().get("type");
        for (Object o : input) {
            if (o == null) continue;
            if (this.strict) {
                return o;
            }
            try {
                switch (type) {
                    case 10: {
                        return DataType.toInteger(o);
                    }
                    case 15: {
                        return DataType.toLong(o);
                    }
                    case 25: {
                        return DataType.toDouble(o);
                    }
                    case 20: {
                        return DataType.toFloat(o);
                    }
                }
                return o;
            }
            catch (Exception e) {
                DataFuException dfe = new DataFuException(e.getMessage(), e);
                dfe.setData(o);
                dfe.setFieldAliases(this.getFieldAliases());
                throw dfe;
            }
        }
        return null;
    }

    @Override
    public Schema getOutputSchema(Schema input) {
        if (input.getFields().size() == 0) {
            throw new RuntimeException("Expected at least one parameter");
        }
        Byte outputType = null;
        int pos = 0;
        for (Schema.FieldSchema field : input.getFields()) {
            if (DataType.isSchemaType((byte)field.type)) {
                throw new RuntimeException(String.format("Not supported on schema types.  Found %s in position %d.", DataType.findTypeName((byte)field.type), pos));
            }
            if (DataType.isComplex((byte)field.type)) {
                throw new RuntimeException(String.format("Not supported on complex types.  Found %s in position %d.", DataType.findTypeName((byte)field.type), pos));
            }
            if (!DataType.isUsableType((byte)field.type)) {
                throw new RuntimeException(String.format("Not a usable type.  Found %s in position %d.", DataType.findTypeName((byte)field.type), pos));
            }
            if (outputType == null) {
                outputType = field.type;
            } else if (!outputType.equals(field.type)) {
                if (this.strict) {
                    throw new RuntimeException(String.format("Expected all types to be equal, but found '%s' in position %d.  First element has type '%s'.  If you'd like to attempt merging types, use the '%s' option, as '%s' is the default.", DataType.findTypeName((byte)field.type), pos, DataType.findTypeName((byte)outputType), LAZY_OPTION, STRICT_OPTION));
                }
                byte merged = DataType.mergeType((byte)outputType, (byte)field.type);
                if (merged == -1) {
                    throw new RuntimeException(String.format("Expected all types to be equal, but found '%s' in position %d, where output type is '%s', and types could not be merged.", DataType.findTypeName((byte)field.type), pos, DataType.findTypeName((byte)outputType)));
                }
                outputType = merged;
            }
            ++pos;
        }
        this.getInstanceProperties().put("type", outputType);
        return new Schema(new Schema.FieldSchema("item", outputType.byteValue()));
    }
}

