/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.util;

import datafu.pig.util.ContextualEvalFunc;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class SimpleEvalFunc<T>
extends ContextualEvalFunc<T> {
    Method m = null;

    public SimpleEvalFunc() {
        for (Method method : ((Object)((Object)this)).getClass().getMethods()) {
            if (method.getName() != "call") continue;
            this.m = method;
        }
        if (this.m == null) {
            throw new IllegalArgumentException(String.format("%s: couldn't find call() method in UDF.", ((Object)((Object)this)).getClass().getName()));
        }
    }

    public Type getReturnType() {
        return this.m.getReturnType();
    }

    private String _method_signature() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
        Class<?>[] pvec = this.m.getParameterTypes();
        sb.append("(");
        for (int i = 0; i < pvec.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.format("%s", pvec[i].getName()));
        }
        sb.append(")");
        return sb.toString();
    }

    public T exec(Tuple input) throws IOException {
        Class<?>[] pvec = this.m.getParameterTypes();
        if (input == null || input.size() == 0) {
            return null;
        }
        if (input.size() != pvec.length) {
            throw new IOException(String.format("%s: got %d arguments, expected %d.", this._method_signature(), input.size(), pvec.length));
        }
        Object[] args = new Object[input.size()];
        for (int i = 0; i < pvec.length; ++i) {
            Object o = input.get(i);
            try {
                o = pvec[i].cast(o);
            }
            catch (ClassCastException e) {
                throw new IOException(String.format("%s: argument type mismatch [#%d]; expected %s, got %s", this._method_signature(), i + 1, pvec[i].getName(), o.getClass().getName()));
            }
            args[i] = o;
        }
        try {
            return (T)this.m.invoke((Object)this, args);
        }
        catch (Exception e) {
            throw new IOException(String.format("%s: caught exception processing input.", this._method_signature()), e);
        }
    }

    @Override
    public Schema outputSchema(Schema inputSchema) {
        if (inputSchema == null) {
            throw new IllegalArgumentException(String.format("%s: null schema passed to %s", this._method_signature(), ((Object)((Object)this)).getClass().getName()));
        }
        Class<?>[] parameterTypes = this.m.getParameterTypes();
        if (inputSchema.size() != parameterTypes.length) {
            throw new IllegalArgumentException(String.format("%s: got %d arguments, expected %d.", this._method_signature(), inputSchema.size(), parameterTypes.length));
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            try {
                byte inputType = inputSchema.getField((int)i).type;
                byte parameterType = DataType.findType(parameterTypes[i]);
                if (inputType == parameterType) continue;
                throw new IllegalArgumentException(String.format("%s: argument type mismatch [#%d]; expected %s, got %s", this._method_signature(), i + 1, DataType.findTypeName((byte)parameterType), DataType.findTypeName((byte)inputType)));
            }
            catch (FrontendException fe) {
                throw new IllegalArgumentException(String.format("%s: Problem with input schema: ", this._method_signature(), inputSchema), fe);
            }
        }
        return super.outputSchema(inputSchema);
    }
}

