/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.util;

import datafu.pig.util.AliasableEvalFunc;
import java.io.IOException;
import java.util.HashMap;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class TransposeTupleToBag
extends AliasableEvalFunc<DataBag> {
    private final String TRANSPOSE_TYPE = "TRANSPOSE_TYPE";

    @Override
    public Schema getOutputSchema(Schema input) {
        try {
            Byte type = null;
            for (Schema.FieldSchema fieldSchema : input.getFields()) {
                if (type == null) {
                    type = fieldSchema.type;
                    continue;
                }
                if (type == fieldSchema.type) continue;
                throw new RuntimeException(String.format("Expected all input types to match.  Got both %s and %s.", DataType.findTypeName((byte)type), DataType.findTypeName((byte)fieldSchema.type)));
            }
            this.getInstanceProperties().put("TRANSPOSE_TYPE", type);
            Schema outputTupleSchema = new Schema();
            outputTupleSchema.add(new Schema.FieldSchema("key", 55));
            outputTupleSchema.add(new Schema.FieldSchema("value", type.byteValue()));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), outputTupleSchema, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    public DataBag exec(Tuple input) throws IOException {
        HashMap<Integer, String> positionToAlias = new HashMap<Integer, String>();
        for (String alias : this.getFieldAliases().keySet()) {
            positionToAlias.put(this.getFieldAliases().get(alias), alias);
        }
        DataBag output = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.size(); ++i) {
            Tuple tuple = TupleFactory.getInstance().newTuple();
            tuple.append(positionToAlias.get(i));
            tuple.append(input.get(i));
            output.add(tuple);
        }
        return output;
    }
}

