/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class TupleDiff
extends EvalFunc<String> {
    public final String added;
    public final String missing;
    public final String changed;
    public final String separator;
    public final String fieldNameChangeSeparator;
    public final String tupleStart;
    public final String tupleEnd;

    public TupleDiff() {
        this("added", "missing", "changed", " ", "/", "(", ")");
    }

    public TupleDiff(String added, String missing, String changed, String separator, String fieldNameChangeSeparator, String tupleStart, String tupleEnd) {
        this.added = added;
        this.missing = missing;
        this.changed = changed;
        this.separator = separator;
        this.fieldNameChangeSeparator = fieldNameChangeSeparator;
        this.tupleStart = tupleStart;
        this.tupleEnd = tupleEnd;
    }

    public String exec(Tuple tuple) throws IOException {
        Schema inputSchema = this.getInputSchema();
        Schema.FieldSchema schema1 = inputSchema != null ? inputSchema.getField(0) : null;
        Schema.FieldSchema schema2 = inputSchema != null ? inputSchema.getField(1) : null;
        HashSet<String> ignoredFields = new HashSet<String>();
        for (int i = 2; i < tuple.size(); ++i) {
            ignoredFields.add((String)tuple.get(i));
        }
        StringBuilder sb = new StringBuilder();
        boolean addedOrMissing = this.compare(tuple.get(0), tuple.get(1), schema1, schema2, 0, sb, null, ignoredFields);
        if (sb.length() == 0) {
            return null;
        }
        String result = sb.toString();
        if (addedOrMissing) {
            return result;
        }
        return this.changed + result;
    }

    private boolean compare(Object oldField, Object newField, Schema.FieldSchema oldSchema, Schema.FieldSchema newSchema, int fieldNum, StringBuilder resultBuilder, StringBuilder prefixBuilder, Set<String> ignoredFields) throws ExecException, FrontendException {
        String alias;
        boolean topLevel = prefixBuilder == null;
        String string = alias = topLevel ? "" : this.getFieldAliasOrNumber(oldSchema, newSchema, fieldNum);
        if (topLevel || prefixBuilder.length() != 0 || !ignoredFields.contains(alias)) {
            if (oldField == null) {
                if (newField != null) {
                    if (topLevel) {
                        resultBuilder.append(this.added);
                        return true;
                    }
                    resultBuilder.append(this.separator).append(prefixBuilder.toString()).append(alias);
                }
            } else if (newField == null) {
                if (topLevel) {
                    resultBuilder.append(this.missing);
                    return true;
                }
                resultBuilder.append(this.separator).append(prefixBuilder.toString()).append(alias);
            } else if (!newField.equals(oldField)) {
                if (topLevel || oldSchema != null && 110 == oldSchema.type) {
                    Tuple oldTuple = (Tuple)oldField;
                    if (!(newField instanceof Tuple)) {
                        resultBuilder.append(this.separator).append(prefixBuilder.toString()).append(alias);
                    } else {
                        Tuple newTuple = (Tuple)newField;
                        int maxNumOfFields = Math.max(oldTuple.size(), newTuple.size());
                        for (int innerFieldNum = 0; innerFieldNum < maxNumOfFields; ++innerFieldNum) {
                            int lengthBeforeCall = resultBuilder.length();
                            this.compare(this.getField(oldTuple, innerFieldNum), this.getField(newTuple, innerFieldNum), this.getFieldSchema(oldSchema, innerFieldNum), this.getFieldSchema(newSchema, innerFieldNum), innerFieldNum, resultBuilder, topLevel ? new StringBuilder() : new StringBuilder(prefixBuilder).append(alias).append(this.tupleStart), ignoredFields);
                            if (topLevel || resultBuilder.length() <= lengthBeforeCall) continue;
                            resultBuilder.append(this.tupleEnd);
                        }
                    }
                } else {
                    resultBuilder.append(this.separator).append(prefixBuilder.toString()).append(alias);
                }
            }
        }
        return false;
    }

    private String getFieldAliasOrNumber(Schema.FieldSchema oldSchema, Schema.FieldSchema newSchema, int fieldNum) {
        String newAlias;
        String oldAlias = oldSchema != null ? oldSchema.alias : null;
        String string = newAlias = newSchema != null ? newSchema.alias : null;
        if (oldAlias == null && newAlias == null) {
            return String.valueOf(fieldNum);
        }
        if (oldAlias != null && oldAlias.equals(newAlias)) {
            return oldAlias;
        }
        return oldAlias + this.fieldNameChangeSeparator + newAlias;
    }

    private Object getField(Tuple tuple, int fieldNum) throws ExecException {
        return tuple.size() < fieldNum + 1 ? null : tuple.get(fieldNum);
    }

    private Schema.FieldSchema getFieldSchema(Schema.FieldSchema fieldSchema, int fieldNum) throws ExecException, FrontendException {
        if (fieldSchema == null) {
            return null;
        }
        Schema schema = fieldSchema.schema;
        return schema.size() < fieldNum + 1 ? null : schema.getField(fieldNum);
    }

    public Schema outputSchema(Schema input) {
        if (input.size() < 2) {
            throw new RuntimeException("Expected input to have at least 2 fields, but has " + input.size());
        }
        return new Schema(new Schema.FieldSchema("tuplediff", 55));
    }
}

