/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import org.apache.comet.CometConf;
import org.apache.comet.parquet.Native;
import org.apache.comet.parquet.TypeUtil;
import org.apache.comet.parquet.Utils;
import org.apache.comet.vector.CometVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnReader
implements AutoCloseable {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractColumnReader.class);
    protected final DataType type;
    protected final ColumnDescriptor descriptor;
    protected final boolean useDecimal128;
    protected final boolean useLegacyDateTimestamp;
    protected int batchSize;
    protected long nativeHandle;

    public AbstractColumnReader(DataType type, ColumnDescriptor descriptor, boolean useDecimal128, boolean useLegacyDateTimestamp) {
        this.type = type;
        this.descriptor = descriptor;
        this.useDecimal128 = useDecimal128;
        this.useLegacyDateTimestamp = useLegacyDateTimestamp;
        TypeUtil.checkParquetType(descriptor, type);
    }

    public ColumnDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setBatchSize(int batchSize) {
        assert (this.nativeHandle == 0L) : "Native column reader shouldn't be initialized before 'setBatchSize' is called";
        this.batchSize = batchSize;
        this.initNative();
    }

    public abstract void readBatch(int var1);

    public abstract CometVector currentBatch();

    @Override
    public void close() {
        if (this.nativeHandle != 0L) {
            LOG.debug("Closing the column reader");
            Native.closeColumnReader(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    protected void initNative() {
        LOG.debug("initializing the native column reader");
        DataType readType = (Boolean)CometConf.COMET_SCHEMA_EVOLUTION_ENABLED().get() != false ? this.type : null;
        boolean useLegacyDateTimestampOrNTZ = this.useLegacyDateTimestamp || this.type == TimestampNTZType$.MODULE$;
        this.nativeHandle = Utils.initColumnReader(this.descriptor, readType, this.batchSize, this.useDecimal128, useLegacyDateTimestampOrNTZ);
    }
}

