/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.VersionInfo;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class CometInputFile
implements InputFile {
    private static final String MAJOR_MINOR_REGEX = "^(\\d+)\\.(\\d+)(\\..*)?$";
    private static final Pattern VERSION_MATCHER = Pattern.compile("^(\\d+)\\.(\\d+)(\\..*)?$");
    private final FileSystem fs;
    private final FileStatus stat;
    private final Configuration conf;

    public static CometInputFile fromPath(Path path, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        return new CometInputFile(fs, fs.getFileStatus(path), conf);
    }

    private CometInputFile(FileSystem fs, FileStatus stat, Configuration conf) {
        this.fs = fs;
        this.stat = stat;
        this.conf = conf;
    }

    public long getLength() {
        return this.stat.getLen();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public Path getPath() {
        return this.stat.getPath();
    }

    public SeekableInputStream newStream() throws IOException {
        FSDataInputStream stream;
        try {
            if (CometInputFile.isAtLeastHadoop33()) {
                FutureDataInputStreamBuilder inputStreamBuilder = this.fs.openFile(this.stat.getPath()).withFileStatus(this.stat);
                if (this.stat.getPath().toString().startsWith("s3a")) {
                    inputStreamBuilder = (FutureDataInputStreamBuilder)inputStreamBuilder.opt("fs.s3a.experimental.input.fadvise", "random");
                }
                stream = (FSDataInputStream)inputStreamBuilder.build().get();
            } else {
                stream = this.fs.open(this.stat.getPath());
            }
        }
        catch (Exception e) {
            throw new IOException("Error when opening file " + this.stat.getPath(), e);
        }
        return HadoopStreams.wrap((FSDataInputStream)stream);
    }

    public SeekableInputStream newStream(long offset, long length) throws IOException {
        try {
            FSDataInputStream stream;
            if (CometInputFile.isAtLeastHadoop33()) {
                FutureDataInputStreamBuilder inputStreamBuilder = this.fs.openFile(this.stat.getPath()).withFileStatus(this.stat);
                if (this.stat.getPath().toString().startsWith("s3a")) {
                    inputStreamBuilder = (FutureDataInputStreamBuilder)((FutureDataInputStreamBuilder)inputStreamBuilder.opt("fs.s3a.experimental.input.fadvise", "random")).opt("fs.s3a.readahead.range", Long.toString(length));
                }
                stream = (FSDataInputStream)inputStreamBuilder.build().get();
            } else {
                stream = this.fs.open(this.stat.getPath());
            }
            return HadoopStreams.wrap((FSDataInputStream)stream);
        }
        catch (Exception e) {
            throw new IOException("Error when opening file " + this.stat.getPath() + ", offset=" + offset + ", length=" + length, e);
        }
    }

    public String toString() {
        return this.stat.getPath().toString();
    }

    private static boolean isAtLeastHadoop33() {
        String version = VersionInfo.getVersion();
        return CometInputFile.isAtLeastHadoop33(version);
    }

    static boolean isAtLeastHadoop33(String version) {
        Matcher matcher = VERSION_MATCHER.matcher(version);
        if (matcher.matches() && matcher.group(1).equals("3")) {
            int minorVersion = Integer.parseInt(matcher.group(2));
            return minorVersion >= 3;
        }
        return false;
    }
}

