/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.InternalColumnDecryptionSetup;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.ColumnIndex;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnIndexReader
implements ColumnIndexStore {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnIndexReader.class);
    private static final IndexStore MISSING_INDEX_STORE = new IndexStore(){

        @Override
        public org.apache.parquet.internal.column.columnindex.ColumnIndex getColumnIndex() {
            return null;
        }

        @Override
        public org.apache.parquet.internal.column.columnindex.OffsetIndex getOffsetIndex() {
            return null;
        }
    };
    private static final ColumnIndexReader EMPTY = new ColumnIndexReader(new BlockMetaData(), Collections.emptySet(), null, null){

        @Override
        public org.apache.parquet.internal.column.columnindex.ColumnIndex getColumnIndex(ColumnPath column) {
            return null;
        }

        @Override
        public org.apache.parquet.internal.column.columnindex.OffsetIndex getOffsetIndex(ColumnPath column) {
            throw new ColumnIndexStore.MissingOffsetIndexException(column);
        }
    };
    private final InternalFileDecryptor fileDecryptor;
    private final SeekableInputStream inputStream;
    private final Map<ColumnPath, IndexStore> store;

    static ColumnIndexReader create(BlockMetaData block, Set<ColumnPath> paths, InternalFileDecryptor fileDecryptor, SeekableInputStream inputStream) {
        try {
            return new ColumnIndexReader(block, paths, fileDecryptor, inputStream);
        }
        catch (ColumnIndexStore.MissingOffsetIndexException e) {
            return EMPTY;
        }
    }

    private ColumnIndexReader(BlockMetaData block, Set<ColumnPath> paths, InternalFileDecryptor fileDecryptor, SeekableInputStream inputStream) {
        this.fileDecryptor = fileDecryptor;
        this.inputStream = inputStream;
        HashMap<ColumnPath, IndexStore> store = new HashMap<ColumnPath, IndexStore>();
        for (ColumnChunkMetaData column : block.getColumns()) {
            ColumnPath path = column.getPath();
            if (!paths.contains(path)) continue;
            store.put(path, new IndexStoreImpl(column));
        }
        this.store = store;
    }

    public org.apache.parquet.internal.column.columnindex.ColumnIndex getColumnIndex(ColumnPath column) {
        return this.store.getOrDefault(column, MISSING_INDEX_STORE).getColumnIndex();
    }

    public org.apache.parquet.internal.column.columnindex.OffsetIndex getOffsetIndex(ColumnPath column) {
        return this.store.getOrDefault(column, MISSING_INDEX_STORE).getOffsetIndex();
    }

    org.apache.parquet.internal.column.columnindex.ColumnIndex readColumnIndex(ColumnChunkMetaData column) throws IOException {
        InternalColumnDecryptionSetup columnDecryptionSetup;
        IndexReference ref = column.getColumnIndexReference();
        if (ref == null) {
            return null;
        }
        this.inputStream.seek(ref.getOffset());
        BlockCipher.Decryptor columnIndexDecryptor = null;
        byte[] columnIndexAAD = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(column.getPath())).isEncrypted()) {
            columnIndexDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            columnIndexAAD = AesCipher.createModuleAAD((byte[])this.fileDecryptor.getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.ColumnIndex, (int)column.getRowGroupOrdinal(), (int)columnDecryptionSetup.getOrdinal(), (int)-1);
        }
        return ParquetMetadataConverter.fromParquetColumnIndex((PrimitiveType)column.getPrimitiveType(), (ColumnIndex)Util.readColumnIndex((InputStream)this.inputStream, columnIndexDecryptor, columnIndexAAD));
    }

    org.apache.parquet.internal.column.columnindex.OffsetIndex readOffsetIndex(ColumnChunkMetaData column) throws IOException {
        InternalColumnDecryptionSetup columnDecryptionSetup;
        IndexReference ref = column.getOffsetIndexReference();
        if (ref == null) {
            return null;
        }
        this.inputStream.seek(ref.getOffset());
        BlockCipher.Decryptor offsetIndexDecryptor = null;
        byte[] offsetIndexAAD = null;
        if (null != this.fileDecryptor && !this.fileDecryptor.plaintextFile() && (columnDecryptionSetup = this.fileDecryptor.getColumnSetup(column.getPath())).isEncrypted()) {
            offsetIndexDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            offsetIndexAAD = AesCipher.createModuleAAD((byte[])this.fileDecryptor.getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.OffsetIndex, (int)column.getRowGroupOrdinal(), (int)columnDecryptionSetup.getOrdinal(), (int)-1);
        }
        return ParquetMetadataConverter.fromParquetOffsetIndex((OffsetIndex)Util.readOffsetIndex((InputStream)this.inputStream, offsetIndexDecryptor, offsetIndexAAD));
    }

    private class IndexStoreImpl
    implements IndexStore {
        private final ColumnChunkMetaData meta;
        private org.apache.parquet.internal.column.columnindex.ColumnIndex columnIndex;
        private boolean columnIndexRead;
        private final org.apache.parquet.internal.column.columnindex.OffsetIndex offsetIndex;

        IndexStoreImpl(ColumnChunkMetaData meta) {
            org.apache.parquet.internal.column.columnindex.OffsetIndex oi;
            this.meta = meta;
            try {
                oi = ColumnIndexReader.this.readOffsetIndex(meta);
            }
            catch (IOException e) {
                LOG.warn("Unable to read offset index for column {}", (Object)meta.getPath(), (Object)e);
                oi = null;
            }
            if (oi == null) {
                throw new ColumnIndexStore.MissingOffsetIndexException(meta.getPath());
            }
            this.offsetIndex = oi;
        }

        @Override
        public org.apache.parquet.internal.column.columnindex.ColumnIndex getColumnIndex() {
            if (!this.columnIndexRead) {
                try {
                    this.columnIndex = ColumnIndexReader.this.readColumnIndex(this.meta);
                }
                catch (IOException e) {
                    LOG.warn("Unable to read column index for column {}", (Object)this.meta.getPath(), (Object)e);
                }
                this.columnIndexRead = true;
            }
            return this.columnIndex;
        }

        @Override
        public org.apache.parquet.internal.column.columnindex.OffsetIndex getOffsetIndex() {
            return this.offsetIndex;
        }
    }

    private static interface IndexStore {
        public org.apache.parquet.internal.column.columnindex.ColumnIndex getColumnIndex();

        public org.apache.parquet.internal.column.columnindex.OffsetIndex getOffsetIndex();
    }
}

