/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.comet.CometConf;
import org.apache.comet.parquet.AbstractColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.shaded.arrow.c.ArrowArray;
import org.apache.comet.shaded.arrow.c.ArrowSchema;
import org.apache.comet.shaded.arrow.c.CometSchemaImporter;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.dictionary.Dictionary;
import org.apache.comet.shaded.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometDictionary;
import org.apache.comet.vector.CometDictionaryVector;
import org.apache.comet.vector.CometPlainVector;
import org.apache.comet.vector.CometVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.spark.sql.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnReader
extends AbstractColumnReader {
    protected static final Logger LOG = LoggerFactory.getLogger(ColumnReader.class);
    private CometDecodedVector currentVector;
    protected CometDictionary dictionary;
    protected PageReader pageReader;
    private boolean firstPageLoaded = false;
    int currentNumNulls;
    int currentNumValues;
    boolean hadNull;
    private final CometSchemaImporter importer;

    public ColumnReader(DataType type, ColumnDescriptor descriptor, CometSchemaImporter importer, int batchSize, boolean useDecimal128, boolean useLegacyDateTimestamp) {
        super(type, descriptor, useDecimal128, useLegacyDateTimestamp);
        assert (batchSize > 0) : "Batch size must be positive, found " + batchSize;
        this.batchSize = batchSize;
        this.importer = importer;
        this.initNative();
    }

    public void setPageReader(PageReader pageReader) throws IOException {
        this.pageReader = pageReader;
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            LOG.debug("dictionary page encoding = {}", (Object)dictionaryPage.getEncoding());
            Native.setDictionaryPage(this.nativeHandle, dictionaryPage.getDictionarySize(), dictionaryPage.getBytes().toByteArray(), dictionaryPage.getEncoding().ordinal());
        }
    }

    @Override
    public void readBatch(int total) {
        int valuesRead;
        LOG.debug("Start to batch of size = " + total);
        if (!this.firstPageLoaded) {
            this.readPage();
            this.firstPageLoaded = true;
        }
        Native.resetBatch(this.nativeHandle);
        int nullsRead = 0;
        for (int left = total; left > 0; left -= valuesRead) {
            int[] array = Native.readBatch(this.nativeHandle, left);
            valuesRead = array[0];
            nullsRead += array[1];
            if (valuesRead >= left) continue;
            this.readPage();
        }
        this.currentNumValues = total;
        this.currentNumNulls = nullsRead;
    }

    @Override
    public CometVector currentBatch() {
        return this.loadVector();
    }

    @Override
    public void close() {
        if (this.currentVector != null) {
            this.currentVector.close();
            this.currentVector = null;
        }
        super.close();
    }

    public CometDecodedVector loadVector() {
        if ((this.hadNull || this.currentNumNulls == 0) && this.currentVector != null && this.dictionary == null && this.currentVector.isFixedLength() && this.currentVector.numValues() >= this.currentNumValues) {
            this.currentVector.setNumNulls(this.currentNumNulls);
            this.currentVector.setNumValues(this.currentNumValues);
            return this.currentVector;
        }
        LOG.debug("Reloading vector");
        if (this.currentVector != null) {
            this.currentVector.close();
        }
        LogicalTypeAnnotation logicalTypeAnnotation = this.descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        boolean isUuid = logicalTypeAnnotation instanceof LogicalTypeAnnotation.UUIDLogicalTypeAnnotation;
        long[] addresses = Native.currentBatch(this.nativeHandle);
        try (ArrowArray array = ArrowArray.wrap(addresses[0]);){
            CometPlainVector cometVector;
            DictionaryEncoding dictionaryEncoding;
            ArrowSchema schema;
            block21: {
                schema = ArrowSchema.wrap(addresses[1]);
                try {
                    FieldVector vector = this.importer.importVector(array, schema);
                    dictionaryEncoding = vector.getField().getDictionary();
                    cometVector = new CometPlainVector(vector, this.useDecimal128);
                    this.hadNull = cometVector.hasNull();
                    if (dictionaryEncoding != null) break block21;
                    if (this.dictionary != null) {
                        this.dictionary = null;
                    }
                    CometDecodedVector cometDecodedVector = this.currentVector = cometVector;
                    if (schema != null) {
                        schema.close();
                    }
                    return cometDecodedVector;
                }
                catch (Throwable throwable) {
                    if (schema != null) {
                        try {
                            schema.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            Dictionary arrowDictionary = this.importer.getProvider().lookup(dictionaryEncoding.getId());
            CometPlainVector dictionaryVector = new CometPlainVector((ValueVector)arrowDictionary.getVector(), this.useDecimal128, isUuid);
            if (this.dictionary != null) {
                this.dictionary.setDictionaryVector(dictionaryVector);
            } else {
                this.dictionary = new CometDictionary(dictionaryVector);
            }
            this.currentVector = new CometDictionaryVector(cometVector, this.dictionary, this.importer.getProvider(), this.useDecimal128, false, isUuid);
            CometDecodedVector cometDecodedVector = this.currentVector = new CometDictionaryVector(cometVector, this.dictionary, this.importer.getProvider(), this.useDecimal128);
            if (schema != null) {
                schema.close();
            }
            return cometDecodedVector;
        }
    }

    protected void readPage() {
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            throw new RuntimeException("overreading: returned DataPage is null");
        }
        final int pageValueCount = page.getValueCount();
        page.accept((DataPage.Visitor)new DataPage.Visitor<Void>(){

            public Void visit(DataPageV1 dataPageV1) {
                LOG.debug("data page encoding = {}", (Object)dataPageV1.getValueEncoding());
                if (dataPageV1.getDlEncoding() != Encoding.RLE && ColumnReader.this.descriptor.getMaxDefinitionLevel() != 0) {
                    throw new UnsupportedOperationException("Unsupported encoding: " + dataPageV1.getDlEncoding());
                }
                if (!ColumnReader.this.isValidValueEncoding(dataPageV1.getValueEncoding())) {
                    throw new UnsupportedOperationException("Unsupported value encoding: " + dataPageV1.getValueEncoding());
                }
                try {
                    boolean useDirectBuffer = (Boolean)CometConf.COMET_PARQUET_ENABLE_DIRECT_BUFFER().get();
                    if (useDirectBuffer) {
                        ByteBuffer buffer = dataPageV1.getBytes().toByteBuffer();
                        Native.setPageBufferV1(ColumnReader.this.nativeHandle, pageValueCount, buffer, dataPageV1.getValueEncoding().ordinal());
                    } else {
                        byte[] array = dataPageV1.getBytes().toByteArray();
                        Native.setPageV1(ColumnReader.this.nativeHandle, pageValueCount, array, dataPageV1.getValueEncoding().ordinal());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }

            public Void visit(DataPageV2 dataPageV2) {
                if (!ColumnReader.this.isValidValueEncoding(dataPageV2.getDataEncoding())) {
                    throw new UnsupportedOperationException("Unsupported encoding: " + dataPageV2.getDataEncoding());
                }
                try {
                    Native.setPageV2(ColumnReader.this.nativeHandle, pageValueCount, dataPageV2.getDefinitionLevels().toByteArray(), dataPageV2.getRepetitionLevels().toByteArray(), dataPageV2.getData().toByteArray(), dataPageV2.getDataEncoding().ordinal());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    private boolean isValidValueEncoding(Encoding encoding) {
        switch (encoding) {
            case PLAIN: 
            case RLE_DICTIONARY: 
            case PLAIN_DICTIONARY: {
                return true;
            }
        }
        return false;
    }
}

