/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import org.apache.comet.parquet.AbstractColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.shaded.arrow.c.ArrowArray;
import org.apache.comet.shaded.arrow.c.ArrowSchema;
import org.apache.comet.shaded.arrow.c.Data;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.memory.RootAllocator;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.vector.CometPlainVector;
import org.apache.comet.vector.CometVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.spark.sql.types.DataType;

public class MetadataColumnReader
extends AbstractColumnReader {
    private final BufferAllocator allocator = new RootAllocator();
    private CometVector vector;

    public MetadataColumnReader(DataType type, ColumnDescriptor descriptor, boolean useDecimal128) {
        super(type, descriptor, useDecimal128, false);
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.close();
        super.setBatchSize(batchSize);
    }

    @Override
    public void readBatch(int total) {
        if (this.vector == null) {
            long[] addresses = Native.currentBatch(this.nativeHandle);
            try (ArrowArray array = ArrowArray.wrap(addresses[0]);
                 ArrowSchema schema = ArrowSchema.wrap(addresses[1]);){
                FieldVector fieldVector = Data.importVector(this.allocator, array, schema, null);
                this.vector = new CometPlainVector(fieldVector, this.useDecimal128);
            }
        }
        this.vector.setNumValues(total);
    }

    void setNumNulls(int total) {
        this.vector.setNumNulls(total);
    }

    @Override
    public CometVector currentBatch() {
        return this.vector;
    }

    @Override
    public void close() {
        if (this.vector != null) {
            this.vector.close();
            this.vector = null;
        }
        super.close();
    }
}

