/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.c;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.comet.shaded.arrow.memory.ArrowBuf;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.memory.util.MemoryUtil;
import org.apache.comet.shaded.arrow.util.Preconditions;

final class Metadata {
    private Metadata() {
    }

    static ArrowBuf encode(BufferAllocator allocator, Map<String, String> metadata) {
        if (metadata == null || metadata.size() == 0) {
            return null;
        }
        ArrayList<byte[]> buffers = new ArrayList<byte[]>(metadata.size() * 2);
        int totalSize = 4 + metadata.size() * 8;
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            byte[] keyBuffer = entry.getKey().getBytes(StandardCharsets.UTF_8);
            byte[] valueBuffer = entry.getValue().getBytes(StandardCharsets.UTF_8);
            totalSize += keyBuffer.length;
            totalSize += valueBuffer.length;
            buffers.add(keyBuffer);
            buffers.add(valueBuffer);
        }
        ArrowBuf result = allocator.buffer(totalSize);
        ByteBuffer writer = MemoryUtil.directBuffer(result.memoryAddress(), totalSize).order(ByteOrder.nativeOrder());
        writer.putInt(metadata.size());
        for (byte[] buffer : buffers) {
            writer.putInt(buffer.length);
            writer.put(buffer);
        }
        return result.slice(0L, totalSize);
    }

    static Map<String, String> decode(long bufferAddress) {
        if (bufferAddress == 0L) {
            return null;
        }
        ByteBuffer reader = MemoryUtil.directBuffer(bufferAddress, Integer.MAX_VALUE).order(ByteOrder.nativeOrder());
        int size = reader.getInt();
        Preconditions.checkState(size >= 0, "Metadata size must not be negative");
        if (size == 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = Metadata.readString(reader);
            String value = Metadata.readString(reader);
            result.put(key, value);
        }
        return result;
    }

    private static String readString(ByteBuffer reader) {
        int length = reader.getInt();
        Preconditions.checkState(length >= 0, "Metadata item length must not be negative");
        String result = "";
        if (length > 0) {
            byte[] dst = new byte[length];
            reader.get(dst);
            result = new String(dst, StandardCharsets.UTF_8);
        }
        return result;
    }
}

