/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.memory.util;

import org.apache.comet.shaded.arrow.util.VisibleForTesting;

public class Float16 {
    public static final short POSITIVE_INFINITY = 31744;
    public static final short NaN = 32256;
    private static final int SIGN_MASK = 32768;
    private static final int EXPONENT_SHIFT = 10;
    private static final int SHIFTED_EXPONENT_MASK = 31;
    private static final int SIGNIFICAND_MASK = 1023;
    private static final int EXPONENT_BIAS = 15;
    private static final int SIGN_SHIFT = 15;
    private static final int EXPONENT_SIGNIFICAND_MASK = Short.MAX_VALUE;
    private static final int FP32_SIGN_SHIFT = 31;
    private static final int FP32_EXPONENT_SHIFT = 23;
    private static final int FP32_SHIFTED_EXPONENT_MASK = 255;
    private static final int FP32_SIGNIFICAND_MASK = 0x7FFFFF;
    private static final int FP32_EXPONENT_BIAS = 127;
    private static final int FP32_QNAN_MASK = 0x400000;
    private static final int FP32_DENORMAL_MAGIC = 0x3F000000;
    private static final float FP32_DENORMAL_FLOAT = Float.intBitsToFloat(0x3F000000);

    @VisibleForTesting
    public static boolean isNaN(short h) {
        return (h & Short.MAX_VALUE) > 31744;
    }

    @VisibleForTesting
    public static int compare(short x, short y) {
        int yBits;
        boolean xIsNaN = Float16.isNaN(x);
        boolean yIsNaN = Float16.isNaN(y);
        if (!xIsNaN && !yIsNaN) {
            int second;
            int first = (x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF;
            int n = second = (y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF;
            if (first < second) {
                return -1;
            }
            if (first > second) {
                return 1;
            }
        }
        int xBits = xIsNaN ? 32256 : (int)x;
        int n = yBits = yIsNaN ? 32256 : (int)y;
        return xBits == yBits ? 0 : (xBits < yBits ? -1 : 1);
    }

    @VisibleForTesting
    public static float toFloat(short b) {
        int bits = b & 0xFFFF;
        int s = bits & 0x8000;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        int outE = 0;
        int outM = 0;
        if (e == 0) {
            if (m != 0) {
                float o = Float.intBitsToFloat(0x3F000000 + m);
                return s == 0 ? o : -(o -= FP32_DENORMAL_FLOAT);
            }
        } else {
            outM = m << 13;
            if (e == 31) {
                outE = 255;
                if (outM != 0) {
                    outM |= 0x400000;
                }
            } else {
                outE = e - 15 + 127;
            }
        }
        int out = s << 16 | outE << 23 | outM;
        return Float.intBitsToFloat(out);
    }

    public static short toFloat16(float f) {
        int bits = Float.floatToRawIntBits(f);
        int s = bits >>> 31;
        int e = bits >>> 23 & 0xFF;
        int m = bits & 0x7FFFFF;
        int outE = 0;
        int outM = 0;
        if (e == 255) {
            outE = 31;
            outM = m != 0 ? 512 : 0;
        } else if ((e = e - 127 + 15) >= 31) {
            outE = 31;
        } else if (e <= 0) {
            int hway;
            int shift;
            int lowm;
            if (e >= -10 && (lowm = (m |= 0x800000) & (1 << (shift = 14 - e)) - 1) + ((outM = m >> shift) & 1) > (hway = 1 << shift - 1)) {
                ++outM;
            }
        } else {
            outE = e;
            outM = m >> 13;
            if ((m & 0x1FFF) + (outM & 1) > 4096) {
                ++outM;
            }
        }
        return (short)(s << 15 | (outE << 10) + outM);
    }

    @VisibleForTesting
    public static String toFloatString(short h) {
        return Float.toString(Float16.toFloat(h));
    }
}

