/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector;

import java.util.ArrayList;
import java.util.List;
import org.apache.comet.shaded.arrow.memory.ArrowBuf;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.shaded.arrow.vector.TypeLayout;
import org.apache.comet.shaded.arrow.vector.VectorSchemaRoot;
import org.apache.comet.shaded.arrow.vector.compression.CompressionCodec;
import org.apache.comet.shaded.arrow.vector.compression.CompressionUtil;
import org.apache.comet.shaded.arrow.vector.compression.NoCompressionCodec;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowRecordBatch;

public class VectorUnloader {
    private final VectorSchemaRoot root;
    private final boolean includeNullCount;
    private final CompressionCodec codec;
    private final boolean alignBuffers;

    public VectorUnloader(VectorSchemaRoot root) {
        this(root, true, NoCompressionCodec.INSTANCE, true);
    }

    public VectorUnloader(VectorSchemaRoot root, boolean includeNullCount, boolean alignBuffers) {
        this(root, includeNullCount, NoCompressionCodec.INSTANCE, alignBuffers);
    }

    public VectorUnloader(VectorSchemaRoot root, boolean includeNullCount, CompressionCodec codec, boolean alignBuffers) {
        this.root = root;
        this.includeNullCount = includeNullCount;
        this.codec = codec == null ? NoCompressionCodec.INSTANCE : codec;
        this.alignBuffers = alignBuffers;
    }

    public ArrowRecordBatch getRecordBatch() {
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (FieldVector vector : this.root.getFieldVectors()) {
            this.appendNodes(vector, nodes, buffers);
        }
        return new ArrowRecordBatch(this.root.getRowCount(), nodes, buffers, CompressionUtil.createBodyCompression(this.codec), this.alignBuffers, false);
    }

    private void appendNodes(FieldVector vector, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers) {
        nodes.add(new ArrowFieldNode(vector.getValueCount(), this.includeNullCount ? (long)vector.getNullCount() : -1L));
        List<ArrowBuf> fieldBuffers = vector.getFieldBuffers();
        int expectedBufferCount = TypeLayout.getTypeBufferCount(vector.getField().getType());
        if (fieldBuffers.size() != expectedBufferCount) {
            throw new IllegalArgumentException(String.format("wrong number of buffers for field %s in vector %s. found: %s", vector.getField(), vector.getClass().getSimpleName(), fieldBuffers));
        }
        for (ArrowBuf buf : fieldBuffers) {
            buf.getReferenceManager().retain();
            buffers.add(this.codec.compress(vector.getAllocator(), buf));
        }
        for (FieldVector child : vector.getChildrenFromFields()) {
            this.appendNodes(child, nodes, buffers);
        }
    }
}

