/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector.ipc;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.comet.shaded.arrow.util.VisibleForTesting;
import org.apache.comet.shaded.arrow.vector.VectorSchemaRoot;
import org.apache.comet.shaded.arrow.vector.compression.CompressionCodec;
import org.apache.comet.shaded.arrow.vector.compression.CompressionUtil;
import org.apache.comet.shaded.arrow.vector.dictionary.Dictionary;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.ipc.ArrowMagic;
import org.apache.comet.shaded.arrow.vector.ipc.ArrowWriter;
import org.apache.comet.shaded.arrow.vector.ipc.InvalidArrowFileException;
import org.apache.comet.shaded.arrow.vector.ipc.WriteChannel;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowBlock;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowFooter;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.comet.shaded.arrow.vector.ipc.message.IpcOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowFileWriter
extends ArrowWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowFileWriter.class);
    private final List<ArrowBlock> dictionaryBlocks = new ArrayList<ArrowBlock>();
    private final List<ArrowBlock> recordBlocks = new ArrayList<ArrowBlock>();
    private Map<String, String> metaData;
    private boolean dictionariesWritten = false;

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out) {
        super(root, provider, out);
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData) {
        super(root, provider, out);
        this.metaData = metaData;
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, IpcOption option) {
        super(root, provider, out, option);
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData, IpcOption option) {
        super(root, provider, out, option);
        this.metaData = metaData;
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData, IpcOption option, CompressionCodec.Factory compressionFactory, CompressionUtil.CodecType codecType) {
        this(root, provider, out, metaData, option, compressionFactory, codecType, Optional.empty());
    }

    public ArrowFileWriter(VectorSchemaRoot root, DictionaryProvider provider, WritableByteChannel out, Map<String, String> metaData, IpcOption option, CompressionCodec.Factory compressionFactory, CompressionUtil.CodecType codecType, Optional<Integer> compressionLevel) {
        super(root, provider, out, option, compressionFactory, codecType, compressionLevel);
        this.metaData = metaData;
    }

    @Override
    protected void startInternal(WriteChannel out) throws IOException {
        ArrowMagic.writeMagic(out, true);
    }

    @Override
    protected ArrowBlock writeDictionaryBatch(ArrowDictionaryBatch batch) throws IOException {
        ArrowBlock block = super.writeDictionaryBatch(batch);
        this.dictionaryBlocks.add(block);
        return block;
    }

    @Override
    protected ArrowBlock writeRecordBatch(ArrowRecordBatch batch) throws IOException {
        ArrowBlock block = super.writeRecordBatch(batch);
        this.recordBlocks.add(block);
        return block;
    }

    @Override
    protected void endInternal(WriteChannel out) throws IOException {
        if (!this.option.write_legacy_ipc_format) {
            out.writeIntLittleEndian(-1);
        }
        out.writeIntLittleEndian(0);
        long footerStart = out.getCurrentPosition();
        out.write(new ArrowFooter(this.schema, this.dictionaryBlocks, this.recordBlocks, this.metaData, this.option.metadataVersion), false);
        int footerLength = (int)(out.getCurrentPosition() - footerStart);
        if (footerLength <= 0) {
            throw new InvalidArrowFileException("invalid footer");
        }
        out.writeIntLittleEndian(footerLength);
        LOGGER.debug("Footer starts at {}, length: {}", (Object)footerStart, (Object)footerLength);
        ArrowMagic.writeMagic(out, false);
        LOGGER.debug("magic written, now at {}", (Object)out.getCurrentPosition());
    }

    @Override
    protected void ensureDictionariesWritten(DictionaryProvider provider, Set<Long> dictionaryIdsUsed) throws IOException {
        if (this.dictionariesWritten) {
            return;
        }
        this.dictionariesWritten = true;
        for (long id : dictionaryIdsUsed) {
            Dictionary dictionary = provider.lookup(id);
            this.writeDictionaryBatch(dictionary);
        }
    }

    @VisibleForTesting
    public List<ArrowBlock> getRecordBlocks() {
        return this.recordBlocks;
    }

    @VisibleForTesting
    public List<ArrowBlock> getDictionaryBlocks() {
        return this.dictionaryBlocks;
    }
}

