/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import java.util.ArrayList;
import java.util.List;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.shaded.arrow.vector.complex.StructVector;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.util.TransferPair;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometVector;
import org.apache.spark.sql.vectorized.ColumnVector;

public class CometStructVector
extends CometDecodedVector {
    final List<ColumnVector> children;
    final DictionaryProvider dictionaryProvider;

    public CometStructVector(ValueVector vector, boolean useDecimal128, DictionaryProvider dictionaryProvider) {
        super(vector, vector.getField(), useDecimal128);
        StructVector structVector = (StructVector)vector;
        int size = structVector.size();
        ArrayList<ColumnVector> children = new ArrayList<ColumnVector>();
        for (int i = 0; i < size; ++i) {
            ValueVector value = structVector.getVectorById(i);
            children.add(CometStructVector.getVector(value, useDecimal128, dictionaryProvider));
        }
        this.children = children;
        this.dictionaryProvider = dictionaryProvider;
    }

    @Override
    public ColumnVector getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public CometVector slice(int offset, int length) {
        TransferPair tp = this.valueVector.getTransferPair(this.valueVector.getAllocator());
        tp.splitAndTransfer(offset, length);
        return new CometStructVector(tp.getTo(), this.useDecimal128, this.dictionaryProvider);
    }
}

