/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet.parquet;

import java.io.Serializable;
import java.util.Locale;
import java.util.UUID;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.comet.parquet.CometSparkToParquetSchemaConverter;
import org.apache.spark.sql.comet.parquet.CometSparkToParquetSchemaConverter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class CometParquetReadSupport$ {
    public static CometParquetReadSupport$ MODULE$;
    private final String SPARK_PARQUET_SCHEMA_NAME;
    private final MessageType EMPTY_MESSAGE;

    static {
        new CometParquetReadSupport$();
    }

    public String SPARK_PARQUET_SCHEMA_NAME() {
        return this.SPARK_PARQUET_SCHEMA_NAME;
    }

    public MessageType EMPTY_MESSAGE() {
        return this.EMPTY_MESSAGE;
    }

    public String generateFakeColumnName() {
        return new StringBuilder(11).append("_fake_name_").append(UUID.randomUUID()).toString();
    }

    public MessageType clipParquetSchema(MessageType parquetSchema, StructType catalystSchema, boolean caseSensitive, boolean useFieldId, boolean ignoreMissingIds) {
        if (!ignoreMissingIds && !this.containsFieldIds((Type)parquetSchema) && ParquetUtils$.MODULE$.hasFieldIds(catalystSchema)) {
            throw new RuntimeException(new StringBuilder(225).append("Spark read schema expects field Ids, but Parquet file schema doesn't contain any field Ids.\nPlease remove the field ids from Spark schema or ignore missing ids by setting `spark.sql.parquet.fieldId.read.ignoreMissing = true`\n").append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("\n             |Spark read schema:\n             |").append(catalystSchema.prettyJson()).append("\n             |\n             |Parquet file schema:\n             |").append(parquetSchema.toString()).append("\n             |").toString())).stripMargin()).toString());
        }
        return this.clipParquetSchema(parquetSchema, catalystSchema, caseSensitive, useFieldId);
    }

    public MessageType clipParquetSchema(MessageType parquetSchema, StructType catalystSchema, boolean caseSensitive, boolean useFieldId) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetSchema.asGroupType(), catalystSchema, caseSensitive, useFieldId);
        return clippedParquetFields.isEmpty() ? this.EMPTY_MESSAGE() : (MessageType)Types.buildMessage().addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(this.SPARK_PARQUET_SCHEMA_NAME());
    }

    private Type clipParquetType(Type parquetType, DataType catalystType, boolean caseSensitive, boolean useFieldId) {
        MapType mapType;
        Type type;
        ArrayType arrayType;
        DataType dataType = catalystType;
        if (dataType instanceof ArrayType && !this.isPrimitiveCatalystType((arrayType = (ArrayType)dataType).elementType())) {
            type = this.clipParquetListType(parquetType.asGroupType(), arrayType.elementType(), caseSensitive, useFieldId);
        } else if (!(!(dataType instanceof MapType) || this.isPrimitiveCatalystType((mapType = (MapType)dataType).keyType()) && this.isPrimitiveCatalystType(mapType.valueType()))) {
            type = this.clipParquetMapType(parquetType.asGroupType(), mapType.keyType(), mapType.valueType(), caseSensitive, useFieldId);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            type = this.clipParquetGroup(parquetType.asGroupType(), structType, caseSensitive, useFieldId);
        } else {
            type = parquetType;
        }
        Type newParquetType = type;
        return useFieldId && parquetType.getId() != null ? newParquetType.withId(parquetType.getId().intValue()) : newParquetType;
    }

    private boolean isPrimitiveCatalystType(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof ArrayType ? true : (dataType2 instanceof MapType ? true : dataType2 instanceof StructType);
        boolean bl2 = !bl;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Type clipParquetListType(GroupType parquetList, DataType elementType, boolean caseSensitive, boolean useFieldId) {
        GroupType repeatedGroup;
        Type type;
        block5: {
            block4: {
                Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(elementType));
                if (parquetList.getLogicalTypeAnnotation() == null && parquetList.isRepetition(Type.Repetition.REPEATED)) {
                    type = this.clipParquetType((Type)parquetList, elementType, caseSensitive, useFieldId);
                    return type;
                }
                Predef$.MODULE$.assert(parquetList.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Invalid Parquet schema. Logical type annotation of annotated Parquet lists must be ListLogicalTypeAnnotation: ").append(parquetList.toString()).toString());
                Predef$.MODULE$.assert(parquetList.getFieldCount() == 1 && parquetList.getType(0).isRepetition(Type.Repetition.REPEATED), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Invalid Parquet schema. LIST-annotated group should only have exactly one repeated field: ").append(parquetList).toString());
                Predef$.MODULE$.assert(!parquetList.getType(0).isPrimitive());
                repeatedGroup = parquetList.getType(0).asGroupType();
                if (repeatedGroup.getFieldCount() > 1) break block4;
                String string = repeatedGroup.getName();
                String string2 = "array";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                String string3 = repeatedGroup.getName();
                String string4 = new StringBuilder(6).append(parquetList.getName()).append("_tuple").toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
            }
            type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.clipParquetType((Type)repeatedGroup, elementType, caseSensitive, useFieldId)).named(parquetList.getName());
            return type;
        }
        GroupType newRepeatedGroup = (GroupType)Types.repeatedGroup().addField(this.clipParquetType(repeatedGroup.getType(0), elementType, caseSensitive, useFieldId)).named(repeatedGroup.getName());
        GroupType newElementType = useFieldId && repeatedGroup.getId() != null ? newRepeatedGroup.withId(repeatedGroup.getId().intValue()) : newRepeatedGroup;
        type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.repeatedGroup().addField(this.clipParquetType(repeatedGroup.getType(0), elementType, caseSensitive, useFieldId)).named(repeatedGroup.getName())).addField((Type)newElementType).named(parquetList.getName());
        return type;
    }

    private GroupType clipParquetMapType(GroupType parquetMap, DataType keyType, DataType valueType, boolean caseSensitive, boolean useFieldId) {
        Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(keyType) || !this.isPrimitiveCatalystType(valueType));
        GroupType repeatedGroup = parquetMap.getType(0).asGroupType();
        Type parquetKeyType = repeatedGroup.getType(0);
        Type parquetValueType = repeatedGroup.getType(1);
        GroupType newRepeatedGroup = (GroupType)((Types.BaseGroupBuilder)Types.repeatedGroup().as(repeatedGroup.getLogicalTypeAnnotation())).addField(this.clipParquetType(parquetKeyType, keyType, caseSensitive, useFieldId)).addField(this.clipParquetType(parquetValueType, valueType, caseSensitive, useFieldId)).named(repeatedGroup.getName());
        GroupType clippedRepeatedGroup = useFieldId && repeatedGroup.getId() != null ? newRepeatedGroup.withId(repeatedGroup.getId().intValue()) : newRepeatedGroup;
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetMap.getRepetition()).as(parquetMap.getLogicalTypeAnnotation())).addField((Type)clippedRepeatedGroup).named(parquetMap.getName());
    }

    private GroupType clipParquetGroup(GroupType parquetRecord, StructType structType, boolean caseSensitive, boolean useFieldId) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetRecord, structType, caseSensitive, useFieldId);
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetRecord.getRepetition()).as(parquetRecord.getLogicalTypeAnnotation())).addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(parquetRecord.getName());
    }

    private Seq<Type> clipParquetGroupFields(GroupType parquetRecord, StructType structType, boolean caseSensitive, boolean useFieldId) {
        LazyRef caseSensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef caseInsensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef idToParquetFieldMap$lzy = new LazyRef();
        boolean x$1 = false;
        boolean x$2 = useFieldId;
        Enumeration.Value x$3 = CometSparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
        CometSparkToParquetSchemaConverter toParquet = new CometSparkToParquetSchemaConverter(x$1, x$3, x$2);
        boolean shouldMatchById = useFieldId && ParquetUtils$.MODULE$.hasFieldIds(structType);
        return (Seq)structType.map((Function1 & Serializable & scala.Serializable)f -> shouldMatchById && ParquetUtils$.MODULE$.hasFieldId(f) ? CometParquetReadSupport$.matchIdField$1(f, caseSensitive, useFieldId, toParquet, idToParquetFieldMap$lzy, parquetRecord) : (caseSensitive ? CometParquetReadSupport$.matchCaseSensitiveField$1(f, caseSensitive, useFieldId, toParquet, caseSensitiveParquetFieldMap$lzy, parquetRecord) : CometParquetReadSupport$.matchCaseInsensitiveField$1(f, caseSensitive, useFieldId, toParquet, caseInsensitiveParquetFieldMap$lzy, parquetRecord)), Seq$.MODULE$.canBuildFrom());
    }

    private boolean containsFieldIds(Type schema2) {
        boolean bl;
        Type type = schema2;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            bl = primitiveType.getId() != null;
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            bl = groupType.getId() != null || ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(groupType.getFields()).asScala()).exists((Function1 & Serializable & scala.Serializable)schema -> BoxesRunTime.boxToBoolean((boolean)CometParquetReadSupport$.MODULE$.containsFieldIds(schema)));
        } else {
            throw new MatchError((Object)type);
        }
        return bl;
    }

    private static final /* synthetic */ Map caseSensitiveParquetFieldMap$lzycompute$1(LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = caseSensitiveParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = caseSensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$1.value() : (Map)caseSensitiveParquetFieldMap$lzy$1.initialize((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        return map;
    }

    private static final Map caseSensitiveParquetFieldMap$1(LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return caseSensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$1.value() : CometParquetReadSupport$.caseSensitiveParquetFieldMap$lzycompute$1(caseSensitiveParquetFieldMap$lzy$1, parquetRecord$1);
    }

    private static final /* synthetic */ Map caseInsensitiveParquetFieldMap$lzycompute$1(LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = caseInsensitiveParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = caseInsensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$1.value() : (Map)caseInsensitiveParquetFieldMap$lzy$1.initialize((Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName().toLowerCase(Locale.ROOT)));
        }
        return map;
    }

    private static final Map caseInsensitiveParquetFieldMap$1(LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return caseInsensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$1.value() : CometParquetReadSupport$.caseInsensitiveParquetFieldMap$lzycompute$1(caseInsensitiveParquetFieldMap$lzy$1, parquetRecord$1);
    }

    public static final /* synthetic */ boolean $anonfun$clipParquetGroupFields$3(Type x$2) {
        return x$2.getId() != null;
    }

    public static final /* synthetic */ int $anonfun$clipParquetGroupFields$4(Type f) {
        return f.getId().intValue();
    }

    private static final /* synthetic */ Map idToParquetFieldMap$lzycompute$1(LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = idToParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = idToParquetFieldMap$lzy$1.initialized() ? (Map)idToParquetFieldMap$lzy$1.value() : (Map)idToParquetFieldMap$lzy$1.initialize((Object)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CometParquetReadSupport$.$anonfun$clipParquetGroupFields$3(x$2)))).groupBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)CometParquetReadSupport$.$anonfun$clipParquetGroupFields$4(f))));
        }
        return map;
    }

    private static final Map idToParquetFieldMap$1(LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return idToParquetFieldMap$lzy$1.initialized() ? (Map)idToParquetFieldMap$lzy$1.value() : CometParquetReadSupport$.idToParquetFieldMap$lzycompute$1(idToParquetFieldMap$lzy$1, parquetRecord$1);
    }

    private static final Type matchCaseSensitiveField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, CometSparkToParquetSchemaConverter toParquet$1, LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return (Type)CometParquetReadSupport$.caseSensitiveParquetFieldMap$1(caseSensitiveParquetFieldMap$lzy$1, parquetRecord$1).get((Object)f.name()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.clipParquetType((Type)x$3, f.dataType(), caseSensitive$1, useFieldId$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet$1.convertField(f));
    }

    private static final Type matchCaseInsensitiveField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, CometSparkToParquetSchemaConverter toParquet$1, LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return (Type)CometParquetReadSupport$.caseInsensitiveParquetFieldMap$1(caseInsensitiveParquetFieldMap$lzy$1, parquetRecord$1).get((Object)f.name().toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw QueryExecutionErrors$.MODULE$.foundDuplicateFieldInCaseInsensitiveModeError(f.name(), parquetTypesString);
            }
            return MODULE$.clipParquetType((Type)parquetTypes.head(), f.dataType(), caseSensitive$1, useFieldId$1);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet$1.convertField(f));
    }

    private static final Type matchIdField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, CometSparkToParquetSchemaConverter toParquet$1, LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        int fieldId = ParquetUtils$.MODULE$.getFieldId(f);
        return (Type)CometParquetReadSupport$.idToParquetFieldMap$1(idToParquetFieldMap$lzy$1, parquetRecord$1).get((Object)BoxesRunTime.boxToInteger((int)fieldId)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw QueryExecutionErrors$.MODULE$.foundDuplicateFieldInFieldIdLookupModeError(fieldId, parquetTypesString);
            }
            return MODULE$.clipParquetType((Type)parquetTypes.head(), f.dataType(), caseSensitive$1, useFieldId$1);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet$1.convertField(f.copy(MODULE$.generateFakeColumnName(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4())));
    }

    private CometParquetReadSupport$() {
        MODULE$ = this;
        this.SPARK_PARQUET_SCHEMA_NAME = "spark_schema";
        this.EMPTY_MESSAGE = Types.buildMessage().named(this.SPARK_PARQUET_SCHEMA_NAME());
    }
}

