/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet.parquet;

import java.io.Serializable;
import org.apache.comet.parquet.CometParquetUtils$;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.comet.parquet.CometSparkToParquetSchemaConverter$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\t\u0012\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0011\b\u0001B\u0001B\u0003%a\u0005C\u0003;\u0001\u0011\u00051\bC\u0003;\u0001\u0011\u0005\u0011\tC\u0003;\u0001\u0011\u0005q\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003b\u0001\u0011\u0005!\rC\u0003b\u0001\u0011%1nB\u0004w#\u0005\u0005\t\u0012A<\u0007\u000fA\t\u0012\u0011!E\u0001q\")!h\u0003C\u0001s\"9!pCI\u0001\n\u0003Y\b\"CA\u0007\u0017E\u0005I\u0011AA\b\u0011!\t\u0019bCI\u0001\n\u0003Y(AI\"p[\u0016$8\u000b]1sWR{\u0007+\u0019:rk\u0016$8k\u00195f[\u0006\u001cuN\u001c<feR,'O\u0003\u0002\u0013'\u00059\u0001/\u0019:rk\u0016$(B\u0001\u000b\u0016\u0003\u0015\u0019w.\\3u\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0019oJLG/\u001a'fO\u0006\u001c\u0017\u0010U1scV,GOR8s[\u0006$\bC\u0001\u0011(\u0013\tA\u0013EA\u0004C_>dW-\u00198\u0002'=,H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3\u0011\u0005-*dB\u0001\u00173\u001d\ti\u0003'D\u0001/\u0015\tyS#\u0001\u0005j]R,'O\\1m\u0013\t\td&A\u0004T#2\u001buN\u001c4\n\u0005M\"\u0014A\u0007)beF,X\r^(viB,H\u000fV5nKN$\u0018-\u001c9UsB,'BA\u0019/\u0013\t1tGA\u0003WC2,X-\u0003\u00029C\tYQI\\;nKJ\fG/[8o\u0003))8/\u001a$jK2$\u0017\nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqrt\b\u0011\t\u0003{\u0001i\u0011!\u0005\u0005\bK\u0011\u0001\n\u00111\u0001'\u0011\u001dIC\u0001%AA\u0002)Bq!\u000f\u0003\u0011\u0002\u0003\u0007a\u0005\u0006\u0002=\u0005\")1)\u0002a\u0001\t\u0006!1m\u001c8g!\tiS)\u0003\u0002G]\t91+\u0015'D_:4GC\u0001\u001fI\u0011\u0015\u0019e\u00011\u0001J!\tQe*D\u0001L\u0015\t\u0019EJ\u0003\u0002N3\u00051\u0001.\u00193p_BL!aT&\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u001d\u0019wN\u001c<feR$\"AU-\u0011\u0005M;V\"\u0001+\u000b\u0005U3\u0016AB:dQ\u0016l\u0017M\u0003\u0002\u00133%\u0011\u0001\f\u0016\u0002\f\u001b\u0016\u001c8/Y4f)f\u0004X\rC\u0003[\u000f\u0001\u00071,\u0001\bdCR\fG._:u'\u000eDW-\\1\u0011\u0005q{V\"A/\u000b\u0005y+\u0012!\u0002;za\u0016\u001c\u0018B\u00011^\u0005)\u0019FO];diRK\b/Z\u0001\rG>tg/\u001a:u\r&,G\u000e\u001a\u000b\u0003G\u001a\u0004\"a\u00153\n\u0005\u0015$&\u0001\u0002+za\u0016DQa\u001a\u0005A\u0002!\fQAZ5fY\u0012\u0004\"\u0001X5\n\u0005)l&aC*ueV\u001cGOR5fY\u0012$2a\u00197n\u0011\u00159\u0017\u00021\u0001i\u0011\u0015q\u0017\u00021\u0001p\u0003)\u0011X\r]3uSRLwN\u001c\t\u0003aNt!aU9\n\u0005I$\u0016\u0001\u0002+za\u0016L!\u0001^;\u0003\u0015I+\u0007/\u001a;ji&|gN\u0003\u0002s)\u0006\u00113i\\7fiN\u0003\u0018M]6U_B\u000b'/];fiN\u001b\u0007.Z7b\u0007>tg/\u001a:uKJ\u0004\"!P\u0006\u0014\u0005-yB#A<\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0005a(F\u0001\u0014~W\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0005v]\u000eDWmY6fI*\u0019\u0011qA\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0005\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u0005+\u0005)j\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007")
public class CometSparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final Enumeration.Value outputTimestampType;
    private final boolean useFieldId;

    public static boolean $lessinit$greater$default$3() {
        return CometSparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static Enumeration.Value $lessinit$greater$default$2() {
        return CometSparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return CometSparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public MessageType convert(StructType catalystSchema) {
        return (MessageType)Types.buildMessage().addFields((Type[])((TraversableOnce)catalystSchema.map((Function1 & Serializable & scala.Serializable)field -> this.convertField((StructField)field), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    /*
     * WARNING - void declaration
     */
    public Type convertField(StructField field) {
        void var2_2;
        Type converted = this.convertField(field, field.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
        return this.useFieldId && ParquetUtils$.MODULE$.hasFieldId(field) ? converted.withId(ParquetUtils$.MODULE$.getFieldId(field)) : var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type convertField(StructField field2, Type.Repetition repetition) {
        Option option;
        Option option2;
        Option option3;
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        DataType dataType = field2.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true)).named(field2.name());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true)).named(field2.name());
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.name());
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.name());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.name());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.name());
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()).named(field2.name());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType()).named(field2.name());
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            Type type;
            Enumeration.Value value = this.outputTimestampType;
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.name());
                return type;
            }
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
                return type;
            }
            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value7 = value;
            if (value6 == null) {
                if (value7 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value6.equals(value7)) throw new MatchError((Object)value);
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)).named(field2.name());
            return type;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)).named(field2.name());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            Option option4 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option4.isEmpty()) {
                int precision = ((Tuple2)option4.get())._1$mcI$sp();
                int scale = ((Tuple2)option4.get())._2$mcI$sp();
                if (this.writeLegacyParquetFormat) {
                    return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
                }
            }
        }
        if (bl && !(option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option3.get())._1$mcI$sp();
            int scale = ((Tuple2)option3.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option2.get())._1$mcI$sp();
            int scale = ((Tuple2)option2.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision)).named(field2.name());
            }
        }
        if (bl && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
            }
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean bl4 = arrayType.containsNull();
            if (bl4 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", elementType, true, StructField$.MODULE$.apply$default$4()))).named("bag")).named(field2.name());
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean bl5 = arrayType.containsNull();
            if (!bl5 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.convertField(new StructField("array", elementType, false, StructField$.MODULE$.apply$default$4()), Type.Repetition.REPEATED)).named(field2.name());
            }
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.name(), (Type)this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4())), (Type)this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4())));
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", elementType, containsNull, StructField$.MODULE$.apply$default$4()))).named("list")).named(field2.name());
            }
        }
        if (bl3) {
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()))).addField(this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()))).named("key_value")).named(field2.name());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return (Type)((Types.Builder)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).foldLeft((Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable & scala.Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field)))).named(field2.name());
        }
        if (!(dataType instanceof UserDefinedType)) throw QueryCompilationErrors$.MODULE$.cannotConvertDataTypeToParquetTypeError(field2);
        UserDefinedType userDefinedType = (UserDefinedType)dataType;
        DataType x$1 = userDefinedType.sqlType();
        String x$2 = field2.copy$default$1();
        boolean x$3 = field2.copy$default$3();
        Metadata x$4 = field2.copy$default$4();
        return this.convertField(field2.copy(x$2, x$1, x$3, x$4));
    }

    public CometSparkToParquetSchemaConverter(boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType, boolean useFieldId) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
        this.useFieldId = useFieldId;
    }

    public CometSparkToParquetSchemaConverter(SQLConf conf) {
        this(conf.writeLegacyParquetFormat(), conf.parquetOutputTimestampType(), CometParquetUtils$.MODULE$.writeFieldId(conf));
    }

    public CometSparkToParquetSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean(), SQLConf.ParquetOutputTimestampType$.MODULE$.withName(conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key())), CometParquetUtils$.MODULE$.writeFieldId(conf));
    }
}

