/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import org.apache.comet.vector.NativeUtil;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.collection.Iterator;

public class CometBatchIterator {
    final Iterator<ColumnarBatch> input;
    final NativeUtil nativeUtil;
    private ColumnarBatch currentBatch = null;

    CometBatchIterator(Iterator<ColumnarBatch> input, NativeUtil nativeUtil) {
        this.input = input;
        this.nativeUtil = nativeUtil;
    }

    public int hasNext() {
        if (this.currentBatch == null && this.input.hasNext()) {
            this.currentBatch = (ColumnarBatch)this.input.next();
        }
        if (this.currentBatch == null) {
            return -1;
        }
        return this.currentBatch.numRows();
    }

    public int next(long[] arrayAddrs, long[] schemaAddrs) {
        if (this.currentBatch == null) {
            return -1;
        }
        int numRows = this.nativeUtil.exportBatch(arrayAddrs, schemaAddrs, this.currentBatch);
        this.currentBatch = null;
        return numRows;
    }
}

