/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet;

import java.io.Serializable;
import java.util.Locale;
import org.apache.comet.ConfigBuilder;
import org.apache.comet.ConfigEntry;
import org.apache.comet.OptionalConfigEntry;
import org.apache.comet.shims.ShimCometConf;
import org.apache.spark.network.util.ByteUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

public final class CometConf$
implements ShimCometConf {
    public static CometConf$ MODULE$;
    private final String COMPAT_GUIDE;
    private final String TUNING_GUIDE;
    private final ListBuffer<ConfigEntry<?>> allConfs;
    private final String COMET_EXEC_CONFIG_PREFIX;
    private final ConfigEntry<Object> COMET_ENABLED;
    private final ConfigEntry<Object> COMET_NATIVE_SCAN_ENABLED;
    private final String SCAN_NATIVE_COMET;
    private final String SCAN_NATIVE_DATAFUSION;
    private final String SCAN_NATIVE_ICEBERG_COMPAT;
    private final ConfigEntry<String> COMET_NATIVE_SCAN_IMPL;
    private final ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_ENABLED;
    private final ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_THREADS;
    private final ConfigEntry<Object> COMET_IO_MERGE_RANGES;
    private final ConfigEntry<Object> COMET_IO_MERGE_RANGES_DELTA;
    private final ConfigEntry<Object> COMET_IO_ADJUST_READRANGE_SKEW;
    private final ConfigEntry<Object> COMET_CONVERT_FROM_PARQUET_ENABLED;
    private final ConfigEntry<Object> COMET_CONVERT_FROM_JSON_ENABLED;
    private final ConfigEntry<Object> COMET_CONVERT_FROM_CSV_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_PROJECT_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_FILTER_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_SORT_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_LOCAL_LIMIT_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_GLOBAL_LIMIT_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_BROADCAST_EXCHANGE_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_HASH_JOIN_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_AGGREGATE_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_COLLECT_LIMIT_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_COALESCE_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_UNION_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_EXPAND_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_WINDOW_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_INITCAP_ENABLED;
    private final ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED;
    private final ConfigEntry<Object> COMET_EXPR_STDDEV_ENABLED;
    private final OptionalConfigEntry<Object> COMET_MEMORY_OVERHEAD;
    private final ConfigEntry<Object> COMET_MEMORY_OVERHEAD_FACTOR;
    private final ConfigEntry<Object> COMET_MEMORY_OVERHEAD_MIN_MIB;
    private final ConfigEntry<Object> COMET_EXEC_SHUFFLE_ENABLED;
    private final ConfigEntry<String> COMET_SHUFFLE_MODE;
    private final ConfigEntry<Object> COMET_SHUFFLE_FALLBACK_TO_COLUMNAR;
    private final ConfigEntry<Object> COMET_EXEC_BROADCAST_FORCE_ENABLED;
    private final ConfigEntry<Object> COMET_REPLACE_SMJ;
    private final ConfigEntry<String> COMET_EXEC_SHUFFLE_COMPRESSION_CODEC;
    private final ConfigEntry<Object> COMET_EXEC_SHUFFLE_COMPRESSION_ZSTD_LEVEL;
    private final ConfigEntry<Object> COMET_SHUFFLE_ENABLE_FAST_ENCODING;
    private final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED;
    private final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM;
    private final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM;
    private final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD;
    private final OptionalConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE;
    private final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR;
    private final ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_BATCH_SIZE;
    private final ConfigEntry<Object> COMET_SHUFFLE_PREFER_DICTIONARY_RATIO;
    private final ConfigEntry<Object> COMET_EXCHANGE_SIZE_MULTIPLIER;
    private final ConfigEntry<Object> COMET_DPP_FALLBACK_ENABLED;
    private final ConfigEntry<Object> COMET_DEBUG_ENABLED;
    private final ConfigEntry<Object> COMET_EXPLAIN_VERBOSE_ENABLED;
    private final ConfigEntry<Object> COMET_EXPLAIN_NATIVE_ENABLED;
    private final ConfigEntry<Object> COMET_EXPLAIN_FALLBACK_ENABLED;
    private final ConfigEntry<Object> COMET_BATCH_SIZE;
    private final ConfigEntry<Object> COMET_PARQUET_ENABLE_DIRECT_BUFFER;
    private final ConfigEntry<String> COMET_EXEC_MEMORY_POOL_TYPE;
    private final ConfigEntry<Object> COMET_SCAN_PREFETCH_ENABLED;
    private final ConfigEntry<Object> COMET_SCAN_PREFETCH_THREAD_NUM;
    private final ConfigEntry<Object> COMET_NATIVE_LOAD_REQUIRED;
    private final ConfigEntry<Object> COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP;
    private final ConfigEntry<Object> COMET_USE_DECIMAL_128;
    private final ConfigEntry<Object> COMET_USE_LAZY_MATERIALIZATION;
    private final ConfigEntry<Object> COMET_SCHEMA_EVOLUTION_ENABLED;
    private final ConfigEntry<Object> COMET_SPARK_TO_ARROW_ENABLED;
    private final ConfigEntry<Seq<String>> COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST;
    private final ConfigEntry<Object> COMET_ANSI_MODE_ENABLED;
    private final ConfigEntry<Object> COMET_CASE_CONVERSION_ENABLED;
    private final ConfigEntry<Object> COMET_SCAN_ALLOW_INCOMPATIBLE;
    private final ConfigEntry<Object> COMET_EXPR_ALLOW_INCOMPATIBLE;
    private final ConfigEntry<Object> COMET_CAST_ALLOW_INCOMPATIBLE;
    private final ConfigEntry<Object> COMET_REGEXP_ALLOW_INCOMPATIBLE;
    private final ConfigEntry<Object> COMET_METRICS_UPDATE_INTERVAL;
    private final boolean COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT;
    private final boolean COMET_ANSI_MODE_ENABLED_DEFAULT;

    static {
        new CometConf$();
    }

    @Override
    public boolean COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT() {
        return this.COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT;
    }

    @Override
    public boolean COMET_ANSI_MODE_ENABLED_DEFAULT() {
        return this.COMET_ANSI_MODE_ENABLED_DEFAULT;
    }

    @Override
    public void org$apache$comet$shims$ShimCometConf$_setter_$COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT_$eq(boolean x$1) {
        this.COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT = x$1;
    }

    @Override
    public void org$apache$comet$shims$ShimCometConf$_setter_$COMET_ANSI_MODE_ENABLED_DEFAULT_$eq(boolean x$1) {
        this.COMET_ANSI_MODE_ENABLED_DEFAULT = x$1;
    }

    public String COMPAT_GUIDE() {
        return this.COMPAT_GUIDE;
    }

    private String TUNING_GUIDE() {
        return this.TUNING_GUIDE;
    }

    public ListBuffer<ConfigEntry<?>> allConfs() {
        return this.allConfs;
    }

    public void register(ConfigEntry<?> conf) {
        this.allConfs().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{conf}));
    }

    public ConfigBuilder conf(String key) {
        return new ConfigBuilder(key);
    }

    public String COMET_EXEC_CONFIG_PREFIX() {
        return this.COMET_EXEC_CONFIG_PREFIX;
    }

    public ConfigEntry<Object> COMET_ENABLED() {
        return this.COMET_ENABLED;
    }

    public ConfigEntry<Object> COMET_NATIVE_SCAN_ENABLED() {
        return this.COMET_NATIVE_SCAN_ENABLED;
    }

    public String SCAN_NATIVE_COMET() {
        return this.SCAN_NATIVE_COMET;
    }

    public String SCAN_NATIVE_DATAFUSION() {
        return this.SCAN_NATIVE_DATAFUSION;
    }

    public String SCAN_NATIVE_ICEBERG_COMPAT() {
        return this.SCAN_NATIVE_ICEBERG_COMPAT;
    }

    public ConfigEntry<String> COMET_NATIVE_SCAN_IMPL() {
        return this.COMET_NATIVE_SCAN_IMPL;
    }

    public boolean isExperimentalNativeScan() {
        boolean bl;
        String string = this.COMET_NATIVE_SCAN_IMPL().get();
        String string2 = this.SCAN_NATIVE_DATAFUSION();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = this.SCAN_NATIVE_ICEBERG_COMPAT();
            String string5 = string;
            bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl) {
            return true;
        }
        String string6 = this.SCAN_NATIVE_COMET();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return false;
        }
        throw new MatchError((Object)string);
    }

    public ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_ENABLED() {
        return this.COMET_PARQUET_PARALLEL_IO_ENABLED;
    }

    public ConfigEntry<Object> COMET_PARQUET_PARALLEL_IO_THREADS() {
        return this.COMET_PARQUET_PARALLEL_IO_THREADS;
    }

    public ConfigEntry<Object> COMET_IO_MERGE_RANGES() {
        return this.COMET_IO_MERGE_RANGES;
    }

    public ConfigEntry<Object> COMET_IO_MERGE_RANGES_DELTA() {
        return this.COMET_IO_MERGE_RANGES_DELTA;
    }

    public ConfigEntry<Object> COMET_IO_ADJUST_READRANGE_SKEW() {
        return this.COMET_IO_ADJUST_READRANGE_SKEW;
    }

    public ConfigEntry<Object> COMET_CONVERT_FROM_PARQUET_ENABLED() {
        return this.COMET_CONVERT_FROM_PARQUET_ENABLED;
    }

    public ConfigEntry<Object> COMET_CONVERT_FROM_JSON_ENABLED() {
        return this.COMET_CONVERT_FROM_JSON_ENABLED;
    }

    public ConfigEntry<Object> COMET_CONVERT_FROM_CSV_ENABLED() {
        return this.COMET_CONVERT_FROM_CSV_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_ENABLED() {
        return this.COMET_EXEC_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_PROJECT_ENABLED() {
        return this.COMET_EXEC_PROJECT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_FILTER_ENABLED() {
        return this.COMET_EXEC_FILTER_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_SORT_ENABLED() {
        return this.COMET_EXEC_SORT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_LOCAL_LIMIT_ENABLED() {
        return this.COMET_EXEC_LOCAL_LIMIT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_GLOBAL_LIMIT_ENABLED() {
        return this.COMET_EXEC_GLOBAL_LIMIT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED() {
        return this.COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_BROADCAST_EXCHANGE_ENABLED() {
        return this.COMET_EXEC_BROADCAST_EXCHANGE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_HASH_JOIN_ENABLED() {
        return this.COMET_EXEC_HASH_JOIN_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_ENABLED() {
        return this.COMET_EXEC_SORT_MERGE_JOIN_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_AGGREGATE_ENABLED() {
        return this.COMET_EXEC_AGGREGATE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_COLLECT_LIMIT_ENABLED() {
        return this.COMET_EXEC_COLLECT_LIMIT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_COALESCE_ENABLED() {
        return this.COMET_EXEC_COALESCE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_UNION_ENABLED() {
        return this.COMET_EXEC_UNION_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_EXPAND_ENABLED() {
        return this.COMET_EXEC_EXPAND_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_WINDOW_ENABLED() {
        return this.COMET_EXEC_WINDOW_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED() {
        return this.COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_INITCAP_ENABLED() {
        return this.COMET_EXEC_INITCAP_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED() {
        return this.COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPR_STDDEV_ENABLED() {
        return this.COMET_EXPR_STDDEV_ENABLED;
    }

    public OptionalConfigEntry<Object> COMET_MEMORY_OVERHEAD() {
        return this.COMET_MEMORY_OVERHEAD;
    }

    public ConfigEntry<Object> COMET_MEMORY_OVERHEAD_FACTOR() {
        return this.COMET_MEMORY_OVERHEAD_FACTOR;
    }

    public ConfigEntry<Object> COMET_MEMORY_OVERHEAD_MIN_MIB() {
        return this.COMET_MEMORY_OVERHEAD_MIN_MIB;
    }

    public ConfigEntry<Object> COMET_EXEC_SHUFFLE_ENABLED() {
        return this.COMET_EXEC_SHUFFLE_ENABLED;
    }

    public ConfigEntry<String> COMET_SHUFFLE_MODE() {
        return this.COMET_SHUFFLE_MODE;
    }

    public ConfigEntry<Object> COMET_SHUFFLE_FALLBACK_TO_COLUMNAR() {
        return this.COMET_SHUFFLE_FALLBACK_TO_COLUMNAR;
    }

    public ConfigEntry<Object> COMET_EXEC_BROADCAST_FORCE_ENABLED() {
        return this.COMET_EXEC_BROADCAST_FORCE_ENABLED;
    }

    public ConfigEntry<Object> COMET_REPLACE_SMJ() {
        return this.COMET_REPLACE_SMJ;
    }

    public ConfigEntry<String> COMET_EXEC_SHUFFLE_COMPRESSION_CODEC() {
        return this.COMET_EXEC_SHUFFLE_COMPRESSION_CODEC;
    }

    public ConfigEntry<Object> COMET_EXEC_SHUFFLE_COMPRESSION_ZSTD_LEVEL() {
        return this.COMET_EXEC_SHUFFLE_COMPRESSION_ZSTD_LEVEL;
    }

    public ConfigEntry<Object> COMET_SHUFFLE_ENABLE_FAST_ENCODING() {
        return this.COMET_SHUFFLE_ENABLE_FAST_ENCODING;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED() {
        return this.COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM() {
        return this.COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM() {
        return this.COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD() {
        return this.COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD;
    }

    public OptionalConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE() {
        return this.COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR() {
        return this.COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR;
    }

    public ConfigEntry<Object> COMET_COLUMNAR_SHUFFLE_BATCH_SIZE() {
        return this.COMET_COLUMNAR_SHUFFLE_BATCH_SIZE;
    }

    public ConfigEntry<Object> COMET_SHUFFLE_PREFER_DICTIONARY_RATIO() {
        return this.COMET_SHUFFLE_PREFER_DICTIONARY_RATIO;
    }

    public ConfigEntry<Object> COMET_EXCHANGE_SIZE_MULTIPLIER() {
        return this.COMET_EXCHANGE_SIZE_MULTIPLIER;
    }

    public ConfigEntry<Object> COMET_DPP_FALLBACK_ENABLED() {
        return this.COMET_DPP_FALLBACK_ENABLED;
    }

    public ConfigEntry<Object> COMET_DEBUG_ENABLED() {
        return this.COMET_DEBUG_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPLAIN_VERBOSE_ENABLED() {
        return this.COMET_EXPLAIN_VERBOSE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPLAIN_NATIVE_ENABLED() {
        return this.COMET_EXPLAIN_NATIVE_ENABLED;
    }

    public ConfigEntry<Object> COMET_EXPLAIN_FALLBACK_ENABLED() {
        return this.COMET_EXPLAIN_FALLBACK_ENABLED;
    }

    public ConfigEntry<Object> COMET_BATCH_SIZE() {
        return this.COMET_BATCH_SIZE;
    }

    public ConfigEntry<Object> COMET_PARQUET_ENABLE_DIRECT_BUFFER() {
        return this.COMET_PARQUET_ENABLE_DIRECT_BUFFER;
    }

    public ConfigEntry<String> COMET_EXEC_MEMORY_POOL_TYPE() {
        return this.COMET_EXEC_MEMORY_POOL_TYPE;
    }

    public ConfigEntry<Object> COMET_SCAN_PREFETCH_ENABLED() {
        return this.COMET_SCAN_PREFETCH_ENABLED;
    }

    public ConfigEntry<Object> COMET_SCAN_PREFETCH_THREAD_NUM() {
        return this.COMET_SCAN_PREFETCH_THREAD_NUM;
    }

    public ConfigEntry<Object> COMET_NATIVE_LOAD_REQUIRED() {
        return this.COMET_NATIVE_LOAD_REQUIRED;
    }

    public ConfigEntry<Object> COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP() {
        return this.COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP;
    }

    public ConfigEntry<Object> COMET_USE_DECIMAL_128() {
        return this.COMET_USE_DECIMAL_128;
    }

    public ConfigEntry<Object> COMET_USE_LAZY_MATERIALIZATION() {
        return this.COMET_USE_LAZY_MATERIALIZATION;
    }

    public ConfigEntry<Object> COMET_SCHEMA_EVOLUTION_ENABLED() {
        return this.COMET_SCHEMA_EVOLUTION_ENABLED;
    }

    public ConfigEntry<Object> COMET_SPARK_TO_ARROW_ENABLED() {
        return this.COMET_SPARK_TO_ARROW_ENABLED;
    }

    public ConfigEntry<Seq<String>> COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST() {
        return this.COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST;
    }

    public ConfigEntry<Object> COMET_ANSI_MODE_ENABLED() {
        return this.COMET_ANSI_MODE_ENABLED;
    }

    public ConfigEntry<Object> COMET_CASE_CONVERSION_ENABLED() {
        return this.COMET_CASE_CONVERSION_ENABLED;
    }

    public ConfigEntry<Object> COMET_SCAN_ALLOW_INCOMPATIBLE() {
        return this.COMET_SCAN_ALLOW_INCOMPATIBLE;
    }

    public ConfigEntry<Object> COMET_EXPR_ALLOW_INCOMPATIBLE() {
        return this.COMET_EXPR_ALLOW_INCOMPATIBLE;
    }

    public ConfigEntry<Object> COMET_CAST_ALLOW_INCOMPATIBLE() {
        return this.COMET_CAST_ALLOW_INCOMPATIBLE;
    }

    public ConfigEntry<Object> COMET_REGEXP_ALLOW_INCOMPATIBLE() {
        return this.COMET_REGEXP_ALLOW_INCOMPATIBLE;
    }

    public ConfigEntry<Object> COMET_METRICS_UPDATE_INTERVAL() {
        return this.COMET_METRICS_UPDATE_INTERVAL;
    }

    private ConfigEntry<Object> createExecEnabledConfig(String exec, boolean defaultValue, Option<String> notes) {
        return this.conf(new StringBuilder(9).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".").append(exec).append(".enabled").toString()).doc(new StringBuilder(30).append("Whether to enable ").append(exec).append(" by default.").append(notes.map((Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(" ").append((String)s).append(".").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString()).booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)defaultValue));
    }

    private Option<String> createExecEnabledConfig$default$3() {
        return None$.MODULE$;
    }

    private CometConf$() {
        MODULE$ = this;
        ShimCometConf.$init$(this);
        this.COMPAT_GUIDE = "For more information, refer to the Comet Compatibility Guide (https://datafusion.apache.org/comet/user-guide/compatibility.html)";
        this.TUNING_GUIDE = "For more information, refer to the Comet Tuning Guide (https://datafusion.apache.org/comet/user-guide/tuning.html)";
        this.allConfs = new ListBuffer();
        this.COMET_EXEC_CONFIG_PREFIX = "spark.comet.exec";
        this.COMET_ENABLED = this.conf("spark.comet.enabled").doc("Whether to enable Comet extension for Spark. When this is turned on, Spark will use Comet to read Parquet data source. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled. By default, this config is the value of the env var `ENABLE_COMET` if set, or true otherwise.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"ENABLE_COMET", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean()));
        this.COMET_NATIVE_SCAN_ENABLED = this.conf("spark.comet.scan.enabled").doc("Whether to enable native scans. When this is turned on, Spark will use Comet to read supported data sources (currently only Parquet is supported natively). Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.SCAN_NATIVE_COMET = "native_comet";
        this.SCAN_NATIVE_DATAFUSION = "native_datafusion";
        this.SCAN_NATIVE_ICEBERG_COMPAT = "native_iceberg_compat";
        this.COMET_NATIVE_SCAN_IMPL = this.conf("spark.comet.scan.impl").doc(new StringBuilder(366).append("The implementation of Comet Native Scan to use. Available modes are '").append(this.SCAN_NATIVE_COMET()).append("',").append("'").append(this.SCAN_NATIVE_DATAFUSION()).append("', and '").append(this.SCAN_NATIVE_ICEBERG_COMPAT()).append("'. ").append("'").append(this.SCAN_NATIVE_COMET()).append("' is for the original Comet native scan which uses a jvm based ").append("parquet file reader and native column decoding. Supports simple types only ").append("'").append(this.SCAN_NATIVE_DATAFUSION()).append("' is a fully native implementation of scan based on DataFusion").append("'").append(this.SCAN_NATIVE_ICEBERG_COMPAT()).append("' is a native implementation that exposes apis to read ").append("parquet columns natively.").toString()).internal().stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).checkValues((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SCAN_NATIVE_COMET(), this.SCAN_NATIVE_DATAFUSION(), this.SCAN_NATIVE_ICEBERG_COMPAT()})))).createWithDefault(((String)package$.MODULE$.env().getOrElse((Object)"COMET_PARQUET_SCAN_IMPL", (Function0 & Serializable & scala.Serializable)() -> MODULE$.SCAN_NATIVE_COMET())).toLowerCase(Locale.ROOT));
        this.COMET_PARQUET_PARALLEL_IO_ENABLED = this.conf("spark.comet.parquet.read.parallel.io.enabled").doc("Whether to enable Comet's parallel reader for Parquet files. The parallel reader reads ranges of consecutive data in a  file in parallel. It is faster for large files and row groups but uses more resources.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.COMET_PARQUET_PARALLEL_IO_THREADS = this.conf("spark.comet.parquet.read.parallel.io.thread-pool.size").doc("The maximum number of parallel threads the parallel reader will use in a single executor. For executors configured with a smaller number of cores, use a smaller number.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)16));
        this.COMET_IO_MERGE_RANGES = this.conf("spark.comet.parquet.read.io.mergeRanges").doc("When enabled the parallel reader will try to merge ranges of data that are separated by less than 'comet.parquet.read.io.mergeRanges.delta' bytes. Longer continuous reads are faster on cloud storage.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.COMET_IO_MERGE_RANGES_DELTA = this.conf("spark.comet.parquet.read.io.mergeRanges.delta").doc("The delta in bytes between consecutive read ranges below which the parallel reader will try to merge the ranges. The default is 8MB.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)0x800000));
        this.COMET_IO_ADJUST_READRANGE_SKEW = this.conf("spark.comet.parquet.read.io.adjust.readRange.skew").doc("In the parallel reader, if the read ranges submitted are skewed in sizes, this option will cause the reader to break up larger read ranges into smaller ranges to reduce the skew. This will result in a slightly larger number of connections opened to the file system but may give improved performance.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_CONVERT_FROM_PARQUET_ENABLED = this.conf("spark.comet.convert.parquet.enabled").doc("When enabled, data from Spark (non-native) Parquet v1 and v2 scans will be converted to Arrow format. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_CONVERT_FROM_JSON_ENABLED = this.conf("spark.comet.convert.json.enabled").doc("When enabled, data from Spark (non-native) JSON v1 and v2 scans will be converted to Arrow format. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_CONVERT_FROM_CSV_ENABLED = this.conf("spark.comet.convert.csv.enabled").doc("When enabled, data from Spark (non-native) CSV v1 and v2 scans will be converted to Arrow format. Note that to enable native vectorized execution, both this config and 'spark.comet.exec.enabled' need to be enabled.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXEC_ENABLED = this.conf(new StringBuilder(8).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".enabled").toString()).doc("Whether to enable Comet native vectorized execution for Spark. This controls whether Spark should convert operators into their Comet counterparts and execute them in native space. Note: each operator is associated with a separate config in the format of 'spark.comet.exec.<operator_name>.enabled' at the moment, and both the config and this need to be turned on, in order for the operator to be executed in native.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.COMET_EXEC_PROJECT_ENABLED = this.createExecEnabledConfig("project", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_FILTER_ENABLED = this.createExecEnabledConfig("filter", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_SORT_ENABLED = this.createExecEnabledConfig("sort", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_LOCAL_LIMIT_ENABLED = this.createExecEnabledConfig("localLimit", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_GLOBAL_LIMIT_ENABLED = this.createExecEnabledConfig("globalLimit", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_BROADCAST_HASH_JOIN_ENABLED = this.createExecEnabledConfig("broadcastHashJoin", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_BROADCAST_EXCHANGE_ENABLED = this.createExecEnabledConfig("broadcastExchange", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_HASH_JOIN_ENABLED = this.createExecEnabledConfig("hashJoin", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_SORT_MERGE_JOIN_ENABLED = this.createExecEnabledConfig("sortMergeJoin", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_AGGREGATE_ENABLED = this.createExecEnabledConfig("aggregate", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_COLLECT_LIMIT_ENABLED = this.createExecEnabledConfig("collectLimit", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_COALESCE_ENABLED = this.createExecEnabledConfig("coalesce", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_UNION_ENABLED = this.createExecEnabledConfig("union", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_EXPAND_ENABLED = this.createExecEnabledConfig("expand", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_WINDOW_ENABLED = this.createExecEnabledConfig("window", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_TAKE_ORDERED_AND_PROJECT_ENABLED = this.createExecEnabledConfig("takeOrderedAndProject", true, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_INITCAP_ENABLED = this.createExecEnabledConfig("initCap", false, this.createExecEnabledConfig$default$3());
        this.COMET_EXEC_SORT_MERGE_JOIN_WITH_JOIN_FILTER_ENABLED = this.conf("spark.comet.exec.sortMergeJoinWithJoinFilter.enabled").doc("Experimental support for Sort Merge Join with filter").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXPR_STDDEV_ENABLED = this.createExecEnabledConfig("stddev", true, (Option<String>)new Some((Object)"stddev is slower than Spark's implementation"));
        this.COMET_MEMORY_OVERHEAD = this.conf("spark.comet.memoryOverhead").doc(new StringBuilder(258).append("The amount of additional memory to be allocated per executor process for Comet, in MiB, when running Spark in on-heap mode. This config is optional. If this is not specified, it will be set to ").append("`spark.comet.memory.overhead.factor` * `spark.executor.memory`. ").append(this.TUNING_GUIDE()).append(".").toString()).bytesConf(ByteUnit.MiB).createOptional();
        this.COMET_MEMORY_OVERHEAD_FACTOR = this.conf("spark.comet.memory.overhead.factor").doc(new StringBuilder(112).append("Fraction of executor memory to be allocated as additional memory for Comet when running Spark in on-heap mode. ").append(this.TUNING_GUIDE()).append(".").toString()).doubleConf().checkValue((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)factor -> factor > 0.0, "Ensure that Comet memory overhead factor is a double greater than 0").createWithDefault(BoxesRunTime.boxToDouble((double)0.2));
        this.COMET_MEMORY_OVERHEAD_MIN_MIB = this.conf("spark.comet.memory.overhead.min").doc(new StringBuilder(129).append("Minimum amount of additional memory to be allocated per executor process for Comet, ").append("in MiB, when running Spark in on-heap mode. ").append(this.TUNING_GUIDE()).append(".").toString()).bytesConf(ByteUnit.MiB).checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= 0L, "Ensure that Comet memory overhead min is a long greater than or equal to 0").createWithDefault(BoxesRunTime.boxToLong((long)384L));
        this.COMET_EXEC_SHUFFLE_ENABLED = this.conf(new StringBuilder(16).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".shuffle.enabled").toString()).doc("Whether to enable Comet native shuffle. Note that this requires setting 'spark.shuffle.manager' to 'org.apache.spark.sql.comet.execution.shuffle.CometShuffleManager'. 'spark.shuffle.manager' must be set before starting the Spark application and cannot be changed during the application.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.COMET_SHUFFLE_MODE = this.conf(new StringBuilder(13).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".shuffle.mode").toString()).doc(new StringBuilder(237).append("This is test config to allow tests to force a particular shuffle implementation to be used. Valid values are `jvm` for Columnar Shuffle, `native` for Native Shuffle, ").append("and `auto` to pick the best supported option (`native` has priority). ").append(this.TUNING_GUIDE()).append(".").toString()).internal().stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(Locale.ROOT)).checkValues((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"native", "jvm", "auto"})))).createWithDefault("auto");
        this.COMET_SHUFFLE_FALLBACK_TO_COLUMNAR = this.conf(new StringBuilder(27).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".shuffle.fallbackToColumnar").toString()).doc("Whether to try falling back to columnar shuffle when native shuffle is not supported").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXEC_BROADCAST_FORCE_ENABLED = this.conf(new StringBuilder(18).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".broadcast.enabled").toString()).doc("Whether to force enabling broadcasting for Comet native operators. Comet broadcast feature will be enabled automatically by Comet extension. But for unit tests, we need this feature to force enabling it for invalid cases. So this config is only used for unit test.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_REPLACE_SMJ = this.conf(new StringBuilder(21).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".replaceSortMergeJoin").toString()).doc(new StringBuilder(142).append("Experimental feature to force Spark to replace SortMergeJoin with ShuffledHashJoin ").append("for improved performance. This feature is not stable yet. ").append(this.TUNING_GUIDE()).append(".").toString()).booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXEC_SHUFFLE_COMPRESSION_CODEC = this.conf(new StringBuilder(26).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".shuffle.compression.codec").toString()).doc("The codec of Comet native shuffle used to compress shuffle data. lz4, zstd, and snappy are supported. Compression can be disabled by setting spark.shuffle.compress=false.").stringConf().checkValues((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zstd", "lz4", "snappy"})))).createWithDefault("lz4");
        this.COMET_EXEC_SHUFFLE_COMPRESSION_ZSTD_LEVEL = this.conf(new StringBuilder(31).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".shuffle.compression.zstd.level").toString()).doc("The compression level to use when compressing shuffle files with zstd.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)1));
        this.COMET_SHUFFLE_ENABLE_FAST_ENCODING = this.conf(new StringBuilder(27).append(this.COMET_EXEC_CONFIG_PREFIX()).append(".shuffle.enableFastEncoding").toString()).doc("Whether to enable Comet's faster proprietary encoding for shuffle blocks rather than using Arrow IPC.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.COMET_COLUMNAR_SHUFFLE_ASYNC_ENABLED = this.conf("spark.comet.columnar.shuffle.async.enabled").doc("Whether to enable asynchronous shuffle for Arrow-based shuffle.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_COLUMNAR_SHUFFLE_ASYNC_THREAD_NUM = this.conf("spark.comet.columnar.shuffle.async.thread.num").doc("Number of threads used for Comet async columnar shuffle per shuffle task. Note that more threads means more memory requirement to buffer shuffle data before flushing to disk. Also, more threads may not always improve performance, and should be set based on the number of cores available.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)3));
        this.COMET_COLUMNAR_SHUFFLE_ASYNC_MAX_THREAD_NUM = this.conf("spark.comet.columnar.shuffle.async.max.thread.num").doc("Maximum number of threads on an executor used for Comet async columnar shuffle. This is the upper bound of total number of shuffle threads per executor. In other words, if the number of cores * the number of shuffle threads per task `spark.comet.columnar.shuffle.async.thread.num` is larger than this config. Comet will use this config as the number of shuffle threads per executor instead.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)100));
        this.COMET_COLUMNAR_SHUFFLE_SPILL_THRESHOLD = this.conf("spark.comet.columnar.shuffle.spill.threshold").doc("Number of rows to be spilled used for Comet columnar shuffle. For every configured number of rows, a new spill file will be created. Higher value means more memory requirement to buffer shuffle data before flushing to disk. As Comet uses columnar shuffle which is columnar format, higher value usually helps to improve shuffle data compression ratio. This is internal config for testing purpose or advanced tuning.").internal().intConf().createWithDefault(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        this.COMET_COLUMNAR_SHUFFLE_MEMORY_SIZE = this.conf("spark.comet.columnar.shuffle.memorySize").internal().doc(new StringBuilder(80).append("Amount of memory to reserve for columnar shuffle when running in on-heap mode. ").append(this.TUNING_GUIDE()).append(".").toString()).bytesConf(ByteUnit.MiB).createOptional();
        this.COMET_COLUMNAR_SHUFFLE_MEMORY_FACTOR = this.conf("spark.comet.columnar.shuffle.memory.factor").internal().doc(new StringBuilder(114).append("Fraction of Comet memory to be allocated per executor process for columnar shuffle ").append("when running in on-heap mode. ").append(this.TUNING_GUIDE()).append(".").toString()).doubleConf().checkValue((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)factor -> factor > 0.0, "Ensure that Comet shuffle memory overhead factor is a double greater than 0").createWithDefault(BoxesRunTime.boxToDouble((double)1.0));
        this.COMET_COLUMNAR_SHUFFLE_BATCH_SIZE = this.conf("spark.comet.columnar.shuffle.batch.size").internal().doc("Batch size when writing out sorted spill files on the native side. Note that this should not be larger than batch size (i.e., `spark.comet.batchSize`). Otherwise it will produce larger batches than expected in the native operator after shuffle.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)8192));
        this.COMET_SHUFFLE_PREFER_DICTIONARY_RATIO = this.conf("spark.comet.shuffle.preferDictionary.ratio").doc("The ratio of total values to distinct values in a string column to decide whether to prefer dictionary encoding when shuffling the column. If the ratio is higher than this config, dictionary encoding will be used on shuffling string column. This config is effective if it is higher than 1.0. Note that this config is only used when `spark.comet.exec.shuffle.mode` is `jvm`.").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)10.0));
        this.COMET_EXCHANGE_SIZE_MULTIPLIER = this.conf("spark.comet.shuffle.sizeInBytesMultiplier").doc("Comet reports smaller sizes for shuffle due to using Arrow's columnar memory format and this can result in Spark choosing a different join strategy due to the estimated size of the exchange being smaller. Comet will multiple sizeInBytes by this amount to avoid regressions in join strategy.").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)1.0));
        this.COMET_DPP_FALLBACK_ENABLED = this.conf("spark.comet.dppFallback.enabled").doc("Whether to fall back to Spark for queries that use DPP.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.COMET_DEBUG_ENABLED = this.conf("spark.comet.debug.enabled").doc("Whether to enable debug mode for Comet. When enabled, Comet will do additional checks for debugging purpose. For example, validating array when importing arrays from JVM at native side. Note that these checks may be expensive in performance and should only be enabled for debugging purpose.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXPLAIN_VERBOSE_ENABLED = this.conf("spark.comet.explain.verbose.enabled").doc("When this setting is enabled, Comet will provide a verbose tree representation of the extended information.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXPLAIN_NATIVE_ENABLED = this.conf("spark.comet.explain.native.enabled").doc("When this setting is enabled, Comet will provide a tree representation of the native query plan before execution and again after execution, with metrics.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXPLAIN_FALLBACK_ENABLED = this.conf("spark.comet.explainFallback.enabled").doc("When this setting is enabled, Comet will provide logging explaining the reason(s) why a query stage cannot be executed natively. Set this to false to reduce the amount of logging.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_BATCH_SIZE = this.conf("spark.comet.batchSize").doc("The columnar batch size, i.e., the maximum number of rows that a batch can contain.").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)8192));
        this.COMET_PARQUET_ENABLE_DIRECT_BUFFER = this.conf("spark.comet.parquet.enable.directBuffer").doc("Whether to use Java direct byte buffer when reading Parquet.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXEC_MEMORY_POOL_TYPE = this.conf("spark.comet.exec.memoryPool").doc(new StringBuilder(440).append("The type of memory pool to be used for Comet native execution. When running Spark in on-heap mode, available pool types are 'greedy', 'fair_spill', 'greedy_task_shared', 'fair_spill_task_shared', 'greedy_global', 'fair_spill_global', and `unbounded`. When running Spark in off-heap mode, available pool types are 'unified' and `fair_unified`. The default pool type is `greedy_task_shared` for on-heap ").append("mode and `unified` for off-heap mode. ").append(this.TUNING_GUIDE()).append(".").toString()).stringConf().createWithDefault("default");
        this.COMET_SCAN_PREFETCH_ENABLED = this.conf("spark.comet.scan.preFetch.enabled").doc("Whether to enable pre-fetching feature of CometScan.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_SCAN_PREFETCH_THREAD_NUM = this.conf("spark.comet.scan.preFetch.threadNum").doc(new StringBuilder(182).append("The number of threads running pre-fetching for CometScan. Effective if ").append(this.COMET_SCAN_PREFETCH_ENABLED().key()).append(" is enabled. Note that more ").append("pre-fetching threads means more memory requirement to store pre-fetched row groups.").toString()).intConf().createWithDefault(BoxesRunTime.boxToInteger((int)2));
        this.COMET_NATIVE_LOAD_REQUIRED = this.conf("spark.comet.nativeLoadRequired").doc("Whether to require Comet native library to load successfully when Comet is enabled. If not, Comet will silently fallback to Spark when it fails to load the native lib. Otherwise, an error will be thrown and the Spark job will be aborted.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXCEPTION_ON_LEGACY_DATE_TIMESTAMP = this.conf("spark.comet.exceptionOnDatetimeRebase").doc("Whether to throw exception when seeing dates/timestamps from the legacy hybrid (Julian + Gregorian) calendar. Since Spark 3, dates/timestamps were written according to the Proleptic Gregorian calendar. When this is true, Comet will throw exceptions when seeing these dates/timestamps that were written by Spark version before 3.0. If this is false, these dates/timestamps will be read as if they were written to the Proleptic Gregorian calendar and will not be rebased.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_USE_DECIMAL_128 = this.conf("spark.comet.use.decimal128").internal().doc("If true, Comet will always use 128 bits to represent a decimal value, regardless of its precision. If false, Comet will use 32, 64 and 128 bits respectively depending on the precision. N.B. this is NOT a user-facing config but should be inferred and set by Comet itself.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_USE_LAZY_MATERIALIZATION = this.conf("spark.comet.use.lazyMaterialization").internal().doc("Whether to enable lazy materialization for Comet. When this is turned on, Comet will read Parquet data source lazily for string and binary columns. For filter operations, lazy materialization will improve read performance by skipping unused pages.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.COMET_SCHEMA_EVOLUTION_ENABLED = this.conf("spark.comet.schemaEvolution.enabled").internal().doc("Whether to enable schema evolution in Comet. For instance, promoting a integer column to a long column, a float column to a double column, etc. This is automaticallyenabled when reading from Iceberg tables.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)this.COMET_SCHEMA_EVOLUTION_ENABLED_DEFAULT()));
        this.COMET_SPARK_TO_ARROW_ENABLED = this.conf("spark.comet.sparkToColumnar.enabled").internal().doc("Whether to enable Spark to Arrow columnar conversion. When this is turned on, Comet will convert operators in `spark.comet.sparkToColumnar.supportedOperatorList` into Arrow columnar format before processing.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_SPARK_TO_ARROW_SUPPORTED_OPERATOR_LIST = this.conf("spark.comet.sparkToColumnar.supportedOperatorList").doc("A comma-separated list of operators that will be converted to Arrow columnar format when 'spark.comet.sparkToColumnar.enabled' is true").stringConf().toSequence().createWithDefault((Seq<String>)new .colon.colon((Object)"Range,InMemoryTableScan", (List)Nil$.MODULE$));
        this.COMET_ANSI_MODE_ENABLED = this.conf("spark.comet.ansi.enabled").internal().doc("Comet does not respect ANSI mode in most cases and by default will not accelerate queries when ansi mode is enabled. Enable this setting to test Comet's experimental support for ANSI mode. This should not be used in production.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)this.COMET_ANSI_MODE_ENABLED_DEFAULT()));
        this.COMET_CASE_CONVERSION_ENABLED = this.conf("spark.comet.caseConversion.enabled").doc("Java uses locale-specific rules when converting strings to upper or lower case and Rust does not, so we disable upper and lower by default.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_SCAN_ALLOW_INCOMPATIBLE = this.conf("spark.comet.scan.allowIncompatible").doc(new StringBuilder(117).append("Comet is not currently fully compatible with Spark for all datatypes. ").append("Set this config to true to allow them anyway. ").append(this.COMPAT_GUIDE()).append(".").toString()).booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_EXPR_ALLOW_INCOMPATIBLE = this.conf("spark.comet.expression.allowIncompatible").doc(new StringBuilder(119).append("Comet is not currently fully compatible with Spark for all expressions. ").append("Set this config to true to allow them anyway. ").append(this.COMPAT_GUIDE()).append(".").toString()).booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_CAST_ALLOW_INCOMPATIBLE = this.conf("spark.comet.cast.allowIncompatible").doc(new StringBuilder(123).append("Comet is not currently fully compatible with Spark for all cast operations. ").append("Set this config to true to allow them anyway. ").append(this.COMPAT_GUIDE()).append(".").toString()).booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_REGEXP_ALLOW_INCOMPATIBLE = this.conf("spark.comet.regexp.allowIncompatible").doc(new StringBuilder(127).append("Comet is not currently fully compatible with Spark for all regular expressions. ").append("Set this config to true to allow them anyway. ").append(this.COMPAT_GUIDE()).append(".").toString()).booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.COMET_METRICS_UPDATE_INTERVAL = this.conf("spark.comet.metrics.updateInterval").doc("The interval in milliseconds to update metrics. If interval is negative, metrics will be updated upon task completion.").longConf().createWithDefault(BoxesRunTime.boxToLong((long)3000L));
    }
}

