/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;

public class IndexFilter {
    private final RowRanges rowRanges;
    private final OffsetIndex offsetIndex;
    private final long totalRowCount;

    public IndexFilter(RowRanges rowRanges, OffsetIndex offsetIndex, long totalRowCount) {
        this.rowRanges = rowRanges;
        this.offsetIndex = offsetIndex;
        this.totalRowCount = totalRowCount;
    }

    OffsetIndex filterOffsetIndex() {
        ArrayList<Integer> indexMap = new ArrayList<Integer>();
        int n = this.offsetIndex.getPageCount();
        for (int i = 0; i < n; ++i) {
            long from = this.offsetIndex.getFirstRowIndex(i);
            if (!this.rowRanges.isOverlapping(from, this.offsetIndex.getLastRowIndex(i, this.totalRowCount))) continue;
            indexMap.add(i);
        }
        int[] indexArray = new int[indexMap.size()];
        for (int i = 0; i < indexArray.length; ++i) {
            indexArray[i] = (Integer)indexMap.get(i);
        }
        return new FilteredOffsetIndex(this.offsetIndex, indexArray);
    }

    List<OffsetRange> calculateOffsetRanges(OffsetIndex filteredOffsetIndex, ColumnChunkMetaData cm) {
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        long firstPageOffset = this.offsetIndex.getOffset(0);
        int n = filteredOffsetIndex.getPageCount();
        if (n > 0) {
            OffsetRange currentRange = null;
            long rowGroupOffset = cm.getStartingPos();
            if (rowGroupOffset < firstPageOffset) {
                currentRange = new OffsetRange(rowGroupOffset, (int)(firstPageOffset - rowGroupOffset));
                ranges.add(currentRange);
            }
            for (int i = 0; i < n; ++i) {
                long offset = filteredOffsetIndex.getOffset(i);
                int length = filteredOffsetIndex.getCompressedPageSize(i);
                if (currentRange != null && currentRange.extend(offset, length)) continue;
                currentRange = new OffsetRange(offset, length);
                ranges.add(currentRange);
            }
        }
        return ranges;
    }

    static class OffsetRange {
        final long offset;
        long length;

        private OffsetRange(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        private boolean extend(long offset, int length) {
            if (this.offset + this.length == offset) {
                this.length += (long)length;
                return true;
            }
            return false;
        }
    }

    private static class FilteredOffsetIndex
    implements OffsetIndex {
        private final OffsetIndex offsetIndex;
        private final int[] indexMap;

        private FilteredOffsetIndex(OffsetIndex offsetIndex, int[] indexMap) {
            this.offsetIndex = offsetIndex;
            this.indexMap = indexMap;
        }

        public int getPageOrdinal(int pageIndex) {
            return this.indexMap[pageIndex];
        }

        public int getPageCount() {
            return this.indexMap.length;
        }

        public long getOffset(int pageIndex) {
            return this.offsetIndex.getOffset(this.indexMap[pageIndex]);
        }

        public int getCompressedPageSize(int pageIndex) {
            return this.offsetIndex.getCompressedPageSize(this.indexMap[pageIndex]);
        }

        public long getFirstRowIndex(int pageIndex) {
            return this.offsetIndex.getFirstRowIndex(this.indexMap[pageIndex]);
        }

        public long getLastRowIndex(int pageIndex, long totalRowCount) {
            int nextIndex = this.indexMap[pageIndex] + 1;
            return (nextIndex >= this.offsetIndex.getPageCount() ? totalRowCount : this.offsetIndex.getFirstRowIndex(nextIndex)) - 1L;
        }
    }
}

