/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import org.apache.comet.CometSchemaImporter;
import org.apache.comet.parquet.AbstractColumnReader;
import org.apache.comet.parquet.Native;
import org.apache.comet.shaded.arrow.c.ArrowArray;
import org.apache.comet.shaded.arrow.c.ArrowSchema;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.memory.RootAllocator;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometDictionary;
import org.apache.comet.vector.CometVector;
import org.apache.comet.vector.NativeUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public class NativeColumnReader
extends AbstractColumnReader {
    protected static final Logger LOG = LoggerFactory.getLogger(NativeColumnReader.class);
    protected final BufferAllocator ALLOCATOR = new RootAllocator();
    private CometDecodedVector currentVector;
    protected CometDictionary dictionary;
    int currentNumValues;
    boolean hadNull;
    private final CometSchemaImporter importer;
    private final NativeUtil nativeUtil;
    private ArrowArray array = null;
    private ArrowSchema schema = null;
    private long nativeBatchHandle = 3735928559L;
    private final int columnNum;

    public NativeColumnReader(long nativeBatchHandle, int columnNum, DataType type, Type fieldType, ColumnDescriptor descriptor, CometSchemaImporter importer, NativeUtil nativeUtil, int batchSize, boolean useDecimal128, boolean useLegacyDateTimestamp) {
        super(type, fieldType, descriptor, useDecimal128, useLegacyDateTimestamp);
        assert (batchSize > 0) : "Batch size must be positive, found " + batchSize;
        this.batchSize = batchSize;
        this.nativeUtil = nativeUtil;
        this.importer = importer;
        this.nativeBatchHandle = nativeBatchHandle;
        this.columnNum = columnNum;
        this.initNative();
    }

    @Override
    protected void initNative() {
        LOG.debug("Native column reader {} is initialized", (Object)String.join((CharSequence)".", this.type.catalogString()));
        this.nativeHandle = 0L;
    }

    @Override
    public void readBatch(int total) {
        LOG.debug("Reading column batch of size = {}", (Object)total);
        this.currentNumValues = total;
    }

    @Override
    public CometVector currentBatch() {
        return this.loadVector();
    }

    @Override
    public void close() {
        if (this.currentVector != null) {
            this.currentVector.close();
            this.currentVector = null;
        }
        super.close();
    }

    public CometDecodedVector loadVector() {
        LOG.debug("Loading vector for next batch");
        if (this.currentVector != null) {
            this.currentVector.close();
        }
        this.array = ArrowArray.allocateNew(this.ALLOCATOR);
        this.schema = ArrowSchema.allocateNew(this.ALLOCATOR);
        long arrayAddr = this.array.memoryAddress();
        long schemaAddr = this.schema.memoryAddress();
        Native.currentColumnBatch(this.nativeBatchHandle, this.columnNum, arrayAddr, schemaAddr);
        ArrowArray[] arrays = new ArrowArray[]{this.array};
        ArrowSchema[] schemas = new ArrowSchema[]{this.schema};
        CometDecodedVector cometVector = (CometDecodedVector)((Object)JavaConverters.seqAsJavaList(this.nativeUtil.importVector(arrays, schemas)).get(0));
        this.hadNull = cometVector.hasNull();
        this.currentVector = cometVector;
        return this.currentVector;
    }
}

