/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.parquet;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import org.apache.comet.parquet.ColumnPageReader;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;

public class RowGroupReader
implements PageReadStore {
    private final Map<ColumnDescriptor, PageReader> readers = new HashMap<ColumnDescriptor, PageReader>();
    private final long rowCount;
    private final RowRanges rowRanges;

    public RowGroupReader(long rowCount) {
        this.rowCount = rowCount;
        this.rowRanges = null;
    }

    RowGroupReader(RowRanges rowRanges) {
        this.rowRanges = rowRanges;
        this.rowCount = rowRanges.rowCount();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public PageReader getPageReader(ColumnDescriptor path) {
        PageReader pageReader = this.readers.get(path);
        if (pageReader == null) {
            throw new IllegalArgumentException(path + " is not found: " + this.readers.keySet() + " " + this.rowCount);
        }
        return pageReader;
    }

    public Optional<PrimitiveIterator.OfLong> getRowIndexes() {
        return this.rowRanges == null ? Optional.empty() : Optional.of(this.rowRanges.iterator());
    }

    void addColumn(ColumnDescriptor path, ColumnPageReader reader) {
        if (this.readers.put(path, reader) != null) {
            throw new IllegalStateException(path + " was already added");
        }
    }
}

