/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.c;

import org.apache.comet.shaded.arrow.c.ArrowArray;
import org.apache.comet.shaded.arrow.c.ArrowSchema;
import org.apache.comet.shaded.arrow.c.CDataDictionaryProvider;
import org.apache.comet.shaded.arrow.c.Data;
import org.apache.comet.shaded.arrow.c.SchemaImporter;
import org.apache.comet.shaded.arrow.memory.BufferAllocator;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.shaded.arrow.vector.types.pojo.Field;

public abstract class AbstractCometSchemaImporter {
    private final BufferAllocator allocator;
    private final SchemaImporter importer;
    private final CDataDictionaryProvider provider = new CDataDictionaryProvider();

    public AbstractCometSchemaImporter(BufferAllocator allocator) {
        this.allocator = allocator;
        this.importer = new SchemaImporter(allocator);
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public CDataDictionaryProvider getProvider() {
        return this.provider;
    }

    public Field importField(ArrowSchema schema) {
        try {
            Field field = this.importer.importField(schema, this.provider);
            return field;
        }
        finally {
            schema.release();
            schema.close();
        }
    }

    public FieldVector importVector(ArrowArray array, ArrowSchema schema) {
        Field field = this.importField(schema);
        FieldVector vector = field.createVector(this.allocator);
        Data.importIntoVector(this.allocator, array, vector, this.provider);
        return vector;
    }

    public void close() {
        this.provider.close();
    }
}

