/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.comet.shaded.arrow.memory.ArrowBuf;
import org.apache.comet.shaded.arrow.util.Collections2;
import org.apache.comet.shaded.arrow.util.Preconditions;
import org.apache.comet.shaded.arrow.vector.FieldVector;
import org.apache.comet.shaded.arrow.vector.TypeLayout;
import org.apache.comet.shaded.arrow.vector.VectorSchemaRoot;
import org.apache.comet.shaded.arrow.vector.compression.CompressionCodec;
import org.apache.comet.shaded.arrow.vector.compression.CompressionUtil;
import org.apache.comet.shaded.arrow.vector.compression.NoCompressionCodec;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.comet.shaded.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.comet.shaded.arrow.vector.types.pojo.Field;

public class VectorLoader {
    private final VectorSchemaRoot root;
    private final CompressionCodec.Factory factory;
    private boolean decompressionNeeded;

    public VectorLoader(VectorSchemaRoot root) {
        this(root, NoCompressionCodec.Factory.INSTANCE);
    }

    public VectorLoader(VectorSchemaRoot root, CompressionCodec.Factory factory) {
        this.root = root;
        this.factory = factory;
    }

    public void load(ArrowRecordBatch recordBatch) {
        Iterator<ArrowBuf> buffers = recordBatch.getBuffers().iterator();
        Iterator<ArrowFieldNode> nodes = recordBatch.getNodes().iterator();
        CompressionUtil.CodecType codecType = CompressionUtil.CodecType.fromCompressionType(recordBatch.getBodyCompression().getCodec());
        this.decompressionNeeded = codecType != CompressionUtil.CodecType.NO_COMPRESSION;
        NoCompressionCodec codec = this.decompressionNeeded ? this.factory.createCodec(codecType) : NoCompressionCodec.INSTANCE;
        for (FieldVector fieldVector : this.root.getFieldVectors()) {
            this.loadBuffers(fieldVector, fieldVector.getField(), buffers, nodes, codec);
        }
        this.root.setRowCount(recordBatch.getLength());
        if (nodes.hasNext() || buffers.hasNext()) {
            throw new IllegalArgumentException("not all nodes and buffers were consumed. nodes: " + Collections2.toString(nodes) + " buffers: " + Collections2.toString(buffers));
        }
    }

    private void loadBuffers(FieldVector vector, Field field, Iterator<ArrowBuf> buffers, Iterator<ArrowFieldNode> nodes, CompressionCodec codec) {
        Preconditions.checkArgument(nodes.hasNext(), "no more field nodes for field %s and vector %s", (Object)field, (Object)vector);
        ArrowFieldNode fieldNode = nodes.next();
        int bufferLayoutCount = TypeLayout.getTypeBufferCount(field.getType());
        ArrayList<ArrowBuf> ownBuffers = new ArrayList<ArrowBuf>(bufferLayoutCount);
        for (int j = 0; j < bufferLayoutCount; ++j) {
            ArrowBuf nextBuf = buffers.next();
            ArrowBuf bufferToAdd = nextBuf.writerIndex() > 0L ? codec.decompress(vector.getAllocator(), nextBuf) : nextBuf;
            ownBuffers.add(bufferToAdd);
            if (!this.decompressionNeeded) continue;
            nextBuf.getReferenceManager().retain();
        }
        try {
            vector.loadFieldBuffers(fieldNode, ownBuffers);
            if (this.decompressionNeeded) {
                for (ArrowBuf buf : ownBuffers) {
                    buf.close();
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load buffers for field " + field + ". error message: " + e.getMessage(), e);
        }
        List<Field> children = field.getChildren();
        if (children.size() > 0) {
            List<FieldVector> childrenFromFields = vector.getChildrenFromFields();
            Preconditions.checkArgument(children.size() == childrenFromFields.size(), "should have as many children as in the schema: found %s expected %s", childrenFromFields.size(), children.size());
            for (int i = 0; i < childrenFromFields.size(); ++i) {
                Field child = children.get(i);
                FieldVector fieldVector = childrenFromFields.get(i);
                this.loadBuffers(fieldVector, child, buffers, nodes, codec);
            }
        }
    }
}

