/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.shaded.arrow.vector.complex.impl;

import java.time.Duration;
import java.time.Period;
import org.apache.comet.shaded.arrow.vector.PeriodDuration;
import org.apache.comet.shaded.arrow.vector.complex.impl.AbstractFieldReader;
import org.apache.comet.shaded.arrow.vector.holders.IntervalMonthDayNanoHolder;
import org.apache.comet.shaded.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import org.apache.comet.shaded.arrow.vector.types.Types;

public class NullableIntervalMonthDayNanoHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalMonthDayNanoHolder holder;

    public NullableIntervalMonthDayNanoHolderReaderImpl(NullableIntervalMonthDayNanoHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALMONTHDAYNANO;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(IntervalMonthDayNanoHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.nanoseconds = this.holder.nanoseconds;
    }

    @Override
    public void read(NullableIntervalMonthDayNanoHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.nanoseconds = this.holder.nanoseconds;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public PeriodDuration readPeriodDuration() {
        if (!this.isSet()) {
            return null;
        }
        return new PeriodDuration(Period.ofMonths(this.holder.months).plusDays(this.holder.days), Duration.ofNanos(this.holder.nanoseconds));
    }

    @Override
    public Object readObject() {
        return this.readPeriodDuration();
    }
}

