/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import org.apache.comet.shaded.arrow.vector.IntVector;
import org.apache.comet.shaded.arrow.vector.dictionary.DictionaryProvider;
import org.apache.comet.shaded.arrow.vector.util.TransferPair;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometDictionary;
import org.apache.comet.vector.CometPlainVector;
import org.apache.comet.vector.CometVector;
import org.apache.parquet.Preconditions;
import org.apache.spark.unsafe.types.UTF8String;

public class CometDictionaryVector
extends CometDecodedVector {
    public final CometPlainVector indices;
    public final CometDictionary values;
    public final DictionaryProvider provider;
    private final boolean isAlias;

    public CometDictionaryVector(CometPlainVector indices, CometDictionary values, DictionaryProvider provider, boolean useDecimal128) {
        this(indices, values, provider, useDecimal128, false, false);
    }

    public CometDictionaryVector(CometPlainVector indices, CometDictionary values, DictionaryProvider provider, boolean useDecimal128, boolean isAlias, boolean isUuid) {
        super(indices.valueVector, values.getValueVector().getField(), useDecimal128, isUuid);
        Preconditions.checkArgument((boolean)(indices.valueVector instanceof IntVector), (String)"'indices' should be a IntVector");
        this.values = values;
        this.indices = indices;
        this.provider = provider;
        this.isAlias = isAlias;
    }

    @Override
    public DictionaryProvider getDictionaryProvider() {
        return this.provider;
    }

    @Override
    public void close() {
        super.close();
        if (!this.isAlias) {
            this.values.close();
        }
    }

    @Override
    public boolean getBoolean(int i) {
        return this.values.decodeToBoolean(this.indices.getInt(i));
    }

    @Override
    public byte getByte(int i) {
        return this.values.decodeToByte(this.indices.getInt(i));
    }

    @Override
    public short getShort(int i) {
        return this.values.decodeToShort(this.indices.getInt(i));
    }

    @Override
    public int getInt(int i) {
        return this.values.decodeToInt(this.indices.getInt(i));
    }

    @Override
    public long getLong(int i) {
        return this.values.decodeToLong(this.indices.getInt(i));
    }

    @Override
    public long getLongDecimal(int i) {
        return this.values.decodeToLongDecimal(this.indices.getInt(i));
    }

    @Override
    public float getFloat(int i) {
        return this.values.decodeToFloat(this.indices.getInt(i));
    }

    @Override
    public double getDouble(int i) {
        return this.values.decodeToDouble(this.indices.getInt(i));
    }

    @Override
    public UTF8String getUTF8String(int i) {
        return this.values.decodeToUTF8String(this.indices.getInt(i));
    }

    @Override
    public byte[] getBinary(int i) {
        return this.values.decodeToBinary(this.indices.getInt(i));
    }

    @Override
    byte[] getBinaryDecimal(int i) {
        return this.values.decodeToBinary(this.indices.getInt(i));
    }

    @Override
    public CometVector slice(int offset, int length) {
        TransferPair tp = this.indices.valueVector.getTransferPair(this.indices.valueVector.getAllocator());
        tp.splitAndTransfer(offset, length);
        CometPlainVector sliced = new CometPlainVector(tp.getTo(), this.useDecimal128);
        return new CometDictionaryVector(sliced, this.values, this.provider, this.useDecimal128, true, this.isUuid);
    }
}

