/*
 * Decompiled with CFR 0.152.
 */
package org.apache.comet.vector;

import org.apache.comet.parquet.LazyColumnReader;
import org.apache.comet.shaded.arrow.vector.ValueVector;
import org.apache.comet.vector.CometDecodedVector;
import org.apache.comet.vector.CometDelegateVector;
import org.apache.spark.sql.types.DataType;

public class CometLazyVector
extends CometDelegateVector {
    private final LazyColumnReader columnReader;

    public CometLazyVector(DataType type, LazyColumnReader columnReader, boolean useDecimal128) {
        super(type, useDecimal128);
        this.columnReader = columnReader;
    }

    public CometDecodedVector getDecodedVector() {
        return (CometDecodedVector)this.delegate;
    }

    @Override
    public ValueVector getValueVector() {
        this.columnReader.readAllBatch();
        this.setDelegate(this.columnReader.loadVector());
        return super.getValueVector();
    }

    @Override
    public void setNumNulls(int numNulls) {
        throw new UnsupportedOperationException("CometLazyVector doesn't support 'setNumNulls'");
    }

    @Override
    public void setNumValues(int numValues) {
        throw new UnsupportedOperationException("CometLazyVector doesn't support 'setNumValues'");
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNull() {
        this.columnReader.readAllBatch();
        this.setDelegate(this.columnReader.loadVector());
        return super.hasNull();
    }

    @Override
    public int numNulls() {
        this.columnReader.readAllBatch();
        this.setDelegate(this.columnReader.loadVector());
        return super.numNulls();
    }

    @Override
    public boolean isNullAt(int rowId) {
        if (this.columnReader.materializeUpToIfNecessary(rowId)) {
            this.setDelegate(this.columnReader.loadVector());
        }
        return super.isNullAt(rowId);
    }
}

