/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.comet;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.comet.vector.CometPlainVector;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.comet.CometBroadcastExchangeExec;
import org.apache.spark.sql.comet.CometBroadcastExchangeExec$;
import org.apache.spark.sql.comet.CometColumnarToRowExec$;
import org.apache.spark.sql.comet.util.Utils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.CodegenSupport;
import org.apache.spark.sql.execution.ColumnarToRowTransition;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnaryExecNode;
import org.apache.spark.sql.execution.adaptive.BroadcastQueryStageExec;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SparkFatalException;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001\u0002\u0014(\u0001JB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005g!)1\n\u0001C\u0001\u0019\")\u0001\u000b\u0001C!#\")a\r\u0001C!O\")\u0001\u000f\u0001C!c\")a\u000f\u0001C)o\"A1\u0010\u0001EC\u0002\u0013\u0005C\u0010C\u0004\u0002\u001e\u0001!\t%a\b\t\u0015\u0005U\u0002\u0001#b\u0001\n\u0013\t9\u0004C\u0005\u0002`\u0001\u0011\r\u0011\"\u0003\u0002b!A\u0011\u0011\u000e\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002p!A\u0011\u0011\u0011\u0001!\u0002\u0013\t\t\b\u0003\u0006\u0002\u0004\u0002A)\u0019!C\u0005\u0003\u000bC!\"a%\u0001\u0011\u000b\u0007I\u0011AAK\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!a/\u0001\t\u0013\ti\fC\u0004\u0002D\u0002!I!!2\t\u000f\u0005e\b\u0001\"\u0015\u0002|\"9\u0011q \u0001\u0005B\t\u0005\u0001b\u0002B\u0003\u0001\u0011E#q\u0001\u0005\n\u0005\u001b\u0001\u0011\u0011!C\u0001\u0005\u001fA\u0011Ba\u0005\u0001#\u0003%\tA!\u0006\t\u0013\t-\u0002!!A\u0005B\t5\u0002\"\u0003B\u001d\u0001\u0005\u0005I\u0011\u0001B\u001e\u0011%\u0011\u0019\u0005AA\u0001\n\u0003\u0011)\u0005C\u0005\u0003L\u0001\t\t\u0011\"\u0011\u0003N!I!1\f\u0001\u0002\u0002\u0013\u0005!Q\f\u0005\n\u0005C\u0002\u0011\u0011!C!\u0005G:\u0011Ba\u001a(\u0003\u0003E\tA!\u001b\u0007\u0011\u0019:\u0013\u0011!E\u0001\u0005WBaa\u0013\u0011\u0005\u0002\te\u0004\"\u0003B>A\u0005\u0005IQ\tB?\u0011%\u0011y\bIA\u0001\n\u0003\u0013\t\tC\u0005\u0003\u0006\u0002\n\t\u0011\"!\u0003\b\"I!q\u0012\u0011\u0002\u0002\u0013%!\u0011\u0013\u0002\u0017\u0007>lW\r^\"pYVlg.\u0019:U_J{w/\u0012=fG*\u0011\u0001&K\u0001\u0006G>lW\r\u001e\u0006\u0003U-\n1a]9m\u0015\taS&A\u0003ta\u0006\u00148N\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001A\n\u0007\u0001MJDhP#\u0011\u0005Q:T\"A\u001b\u000b\u0005YJ\u0013!C3yK\u000e,H/[8o\u0013\tATGA\u0005Ta\u0006\u00148\u000e\u00157b]B\u0011AGO\u0005\u0003wU\u0012qcQ8mk6t\u0017M\u001d+p%><HK]1og&$\u0018n\u001c8\u0011\u0005Qj\u0014B\u0001 6\u00059\u0019u\u000eZ3hK:\u001cV\u000f\u001d9peR\u0004\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A\r&\u0011q)\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002g\u000511\r[5mI\u0002\na\u0001P5oSRtDCA'P!\tq\u0005!D\u0001(\u0011\u0015A5\u00011\u00014\u0003\u0019yW\u000f\u001e9viV\t!\u000bE\u0002T7zs!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005]\u000b\u0014A\u0002\u001fs_>$h(C\u0001C\u0013\tQ\u0016)A\u0004qC\u000e\\\u0017mZ3\n\u0005qk&aA*fc*\u0011!,\u0011\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\f1\"\u001a=qe\u0016\u001c8/[8og*\u00111-K\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\r\u0019\u0002\n\u0003R$(/\u001b2vi\u0016\f!c\\;uaV$\b+\u0019:uSRLwN\\5oOV\t\u0001\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u0006A\u0001\u000f[=tS\u000e\fGN\u0003\u0002nE\u0006)\u0001\u000f\\1og&\u0011qN\u001b\u0002\r!\u0006\u0014H/\u001b;j_:LgnZ\u0001\u000f_V$\b/\u001e;Pe\u0012,'/\u001b8h+\u0005\u0011\bcA*\\gB\u0011q\f^\u0005\u0003k\u0002\u0014\u0011bU8si>\u0013H-\u001a:\u0002/\r\fgn\u00115fG.d\u0015.\\5u\u001d>$(+Z1dQ\u0016$W#\u0001=\u0011\u0005\u0001K\u0018B\u0001>B\u0005\u001d\u0011un\u001c7fC:\fq!\\3ue&\u001c7/F\u0001~!\u001dq\u0018QAA\u0006\u0003#q1a`A\u0001!\t)\u0016)C\u0002\u0002\u0004\u0005\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u00111!T1q\u0015\r\t\u0019!\u0011\t\u0004}\u00065\u0011\u0002BA\b\u0003\u0013\u0011aa\u0015;sS:<\u0007\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]Q'\u0001\u0004nKR\u0014\u0018nY\u0005\u0005\u00037\t)BA\u0005T#2kU\r\u001e:jG\u0006IAm\\#yK\u000e,H/\u001a\u000b\u0003\u0003C\u0001b!a\t\u0002*\u00055RBAA\u0013\u0015\r\t9cK\u0001\u0004e\u0012$\u0017\u0002BA\u0016\u0003K\u00111A\u0015#E!\u0011\ty#!\r\u000e\u0003\tL1!a\rc\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000fA\u0014x.\\5tKV\u0011\u0011\u0011\b\t\u0007\u0003w\t\t%!\u0012\u000e\u0005\u0005u\"bAA \u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\r\u0013Q\b\u0002\b!J|W.[:f!\u0019\t9%!\u0014\u0002R5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017Z\u0013!\u00032s_\u0006$7-Y:u\u0013\u0011\ty%!\u0013\u0003\u0013\t\u0013x.\u00193dCN$\bc\u0001!\u0002T%\u0019\u0011QK!\u0003\u0007\u0005s\u0017\u0010K\u0002\u000b\u00033\u00022\u0001QA.\u0013\r\ti&\u0011\u0002\niJ\fgn]5f]R\fq\u0001^5nK>,H/\u0006\u0002\u0002dA\u0019\u0001)!\u001a\n\u0007\u0005\u001d\u0014I\u0001\u0003M_:<\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011)\u00071\tI&A\u0003sk:LE-\u0006\u0002\u0002rA!\u00111OA?\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014\u0001B;uS2T!!a\u001f\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\n)H\u0001\u0003V+&#\u0015A\u0002:v]&#\u0007%\u0001\fd_6,GO\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f+\t\t9\tE\u0003A\u0003\u0013\u000bi)C\u0002\u0002\f\u0006\u0013aa\u00149uS>t\u0007c\u0001(\u0002\u0010&\u0019\u0011\u0011S\u0014\u00035\r{W.\u001a;Ce>\fGmY1ti\u0016C8\r[1oO\u0016,\u00050Z2\u0002\u001dI,G.\u0019;j_:4U\u000f^;sKV\u0011\u0011q\u0013\t\u0007\u00033\u000bi*!\u0012\u000e\u0005\u0005m%\u0002BA \u0003kJA!a(\u0002\u001c\n1a)\u001e;ve\u0016D3\u0001EA-\u0003I!w.\u0012=fGV$XM\u0011:pC\u0012\u001c\u0017m\u001d;\u0016\t\u0005\u001d\u0016q\u0016\u000b\u0003\u0003S\u0003b!a\u0012\u0002N\u0005-\u0006\u0003BAW\u0003_c\u0001\u0001B\u0004\u00022F\u0011\r!a-\u0003\u0003Q\u000bB!!.\u0002RA\u0019\u0001)a.\n\u0007\u0005e\u0016IA\u0004O_RD\u0017N\\4\u00025\u0019Lg\u000eZ\"p[\u0016$(I]8bI\u000e\f7\u000f^#yG\"\fgnZ3\u0015\t\u0005\u001d\u0015q\u0018\u0005\u0007\u0003\u0003\u0014\u0002\u0019A\u001a\u0002\u0005=\u0004\u0018aE4f]\u000e{G-Z\"pYVlgNV3di>\u0014H\u0003DAd\u0003'\fi.!9\u0002f\u0006U\b\u0003BAe\u0003\u001fl!!a3\u000b\u0007\u00055\u0007-A\u0004d_\u0012,w-\u001a8\n\t\u0005E\u00171\u001a\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q[\nA\u0002\u0005]\u0017aA2uqB!\u0011\u0011ZAm\u0013\u0011\tY.a3\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011q\\\nA\u0002\u0005-\u0011!C2pYVlgNV1s\u0011\u001d\t\u0019o\u0005a\u0001\u0003\u0017\tqa\u001c:eS:\fG\u000eC\u0004\u0002hN\u0001\r!!;\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0004\u0003_L\u0013!\u0002;za\u0016\u001c\u0018\u0002BAz\u0003[\u0014\u0001\u0002R1uCRK\b/\u001a\u0005\u0007\u0003o\u001c\u0002\u0019\u0001=\u0002\u00119,H\u000e\\1cY\u0016\f\u0011\u0002Z8Qe>$WoY3\u0015\t\u0005-\u0011Q \u0005\b\u0003+$\u0002\u0019AAl\u0003%Ig\u000e];u%\u0012#5\u000f\u0006\u0002\u0003\u0004A!1kWA\u0011\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019QJ!\u0003\t\r\t-a\u00031\u00014\u0003!qWm^\"iS2$\u0017\u0001B2paf$2!\u0014B\t\u0011\u001dAu\u0003%AA\u0002M\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0018)\u001a1G!\u0007,\u0005\tm\u0001\u0003\u0002B\u000f\u0005Oi!Aa\b\u000b\t\t\u0005\"1E\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\nB\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005S\u0011yBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0018!\u0011\u0011\tDa\u000e\u000e\u0005\tM\"\u0002\u0002B\u001b\u0003s\nA\u0001\\1oO&!\u0011q\u0002B\u001a\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011i\u0004E\u0002A\u0005\u007fI1A!\u0011B\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\tFa\u0012\t\u0013\t%3$!AA\u0002\tu\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003PA1!\u0011\u000bB,\u0003#j!Aa\u0015\u000b\u0007\tU\u0013)\u0001\u0006d_2dWm\u0019;j_:LAA!\u0017\u0003T\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rA(q\f\u0005\n\u0005\u0013j\u0012\u0011!a\u0001\u0003#\na!Z9vC2\u001cHc\u0001=\u0003f!I!\u0011\n\u0010\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u0017\u0007>lW\r^\"pYVlg.\u0019:U_J{w/\u0012=fGB\u0011a\nI\n\u0005A\t5T\t\u0005\u0004\u0003p\tU4'T\u0007\u0003\u0005cR1Aa\u001dB\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u001e\u0003r\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\t%\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t=\u0012!B1qa2LHcA'\u0003\u0004\")\u0001j\ta\u0001g\u00059QO\\1qa2LH\u0003\u0002BE\u0005\u0017\u0003B\u0001QAEg!A!Q\u0012\u0013\u0002\u0002\u0003\u0007Q*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0013\t\u0005\u0005c\u0011)*\u0003\u0003\u0003\u0018\nM\"AB(cU\u0016\u001cG\u000f")
public class CometColumnarToRowExec
extends SparkPlan
implements ColumnarToRowTransition,
CodegenSupport {
    private Map<String, SQLMetric> metrics;
    private transient Promise<Broadcast<Object>> promise;
    private Option<CometBroadcastExchangeExec> cometBroadcastExchange;
    private transient Future<Broadcast<Object>> relationFuture;
    private final SparkPlan child;
    private final transient long timeout;
    private final UUID runId;
    private CodegenSupport parent;
    private transient Seq<SparkPlan> children;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<SparkPlan> unapply(CometColumnarToRowExec cometColumnarToRowExec) {
        return CometColumnarToRowExec$.MODULE$.unapply(cometColumnarToRowExec);
    }

    public static <A> Function1<SparkPlan, A> andThen(Function1<CometColumnarToRowExec, A> function1) {
        return CometColumnarToRowExec$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, CometColumnarToRowExec> compose(Function1<A, SparkPlan> function1) {
        return CometColumnarToRowExec$.MODULE$.compose(function1);
    }

    public String metricTerm(CodegenContext ctx, String name) {
        return CodegenSupport.metricTerm$((CodegenSupport)this, (CodegenContext)ctx, (String)name);
    }

    public boolean supportCodegen() {
        return CodegenSupport.supportCodegen$((CodegenSupport)this);
    }

    public final String produce(CodegenContext ctx, CodegenSupport parent) {
        return CodegenSupport.produce$((CodegenSupport)this, (CodegenContext)ctx, (CodegenSupport)parent);
    }

    public final String consume(CodegenContext ctx, Seq<ExprCode> outputVars, String row) {
        return CodegenSupport.consume$((CodegenSupport)this, (CodegenContext)ctx, outputVars, (String)row);
    }

    public final String consume$default$3() {
        return CodegenSupport.consume$default$3$((CodegenSupport)this);
    }

    public String evaluateVariables(Seq<ExprCode> variables) {
        return CodegenSupport.evaluateVariables$((CodegenSupport)this, variables);
    }

    public String evaluateRequiredVariables(Seq<Attribute> attributes, Seq<ExprCode> variables, AttributeSet required) {
        return CodegenSupport.evaluateRequiredVariables$((CodegenSupport)this, attributes, variables, (AttributeSet)required);
    }

    public String evaluateNondeterministicVariables(Seq<Attribute> attributes, Seq<ExprCode> variables, Seq<NamedExpression> expressions) {
        return CodegenSupport.evaluateNondeterministicVariables$((CodegenSupport)this, attributes, variables, expressions);
    }

    public AttributeSet usedInputs() {
        return CodegenSupport.usedInputs$((CodegenSupport)this);
    }

    public String doConsume(CodegenContext ctx, Seq<ExprCode> input, ExprCode row) {
        return CodegenSupport.doConsume$((CodegenSupport)this, (CodegenContext)ctx, input, (ExprCode)row);
    }

    public boolean needCopyResult() {
        return CodegenSupport.needCopyResult$((CodegenSupport)this);
    }

    public boolean needStopCheck() {
        return CodegenSupport.needStopCheck$((CodegenSupport)this);
    }

    public String shouldStopCheckCode() {
        return CodegenSupport.shouldStopCheckCode$((CodegenSupport)this);
    }

    public Seq<String> limitNotReachedChecks() {
        return CodegenSupport.limitNotReachedChecks$((CodegenSupport)this);
    }

    public final String limitNotReachedCond() {
        return CodegenSupport.limitNotReachedCond$((CodegenSupport)this);
    }

    public /* synthetic */ String org$apache$spark$sql$execution$UnaryExecNode$$super$formattedNodeName() {
        return super.formattedNodeName();
    }

    public String verboseStringWithOperatorId() {
        return UnaryExecNode.verboseStringWithOperatorId$((UnaryExecNode)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$((UnaryLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$((UnaryLike)this, (IndexedSeq)newChildren);
    }

    public CodegenSupport parent() {
        return this.parent;
    }

    public void parent_$eq(CodegenSupport x$1) {
        this.parent = x$1;
    }

    private Seq<SparkPlan> children$lzycompute() {
        CometColumnarToRowExec cometColumnarToRowExec = this;
        synchronized (cometColumnarToRowExec) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.children = UnaryLike.children$((UnaryLike)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.children;
    }

    public final Seq<SparkPlan> children() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public SparkPlan child() {
        return this.child;
    }

    public Seq<Attribute> output() {
        return this.child().output();
    }

    public Partitioning outputPartitioning() {
        return this.child().outputPartitioning();
    }

    public Seq<SortOrder> outputOrdering() {
        return this.child().outputOrdering();
    }

    public boolean canCheckLimitNotReached() {
        return true;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CometColumnarToRowExec cometColumnarToRowExec = this;
        synchronized (cometColumnarToRowExec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOutputRows"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "number of output rows")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numInputBatches"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "number of input batches"))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public RDD<InternalRow> doExecute() {
        SQLMetric numOutputRows = this.longMetric("numOutputRows");
        SQLMetric numInputBatches = this.longMetric("numInputBatches");
        Seq<Attribute> localOutput = this.output();
        RDD qual$1 = this.child().executeColumnar();
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)batches -> {
            UnsafeProjection toUnsafe = UnsafeProjection$.MODULE$.create(localOutput, localOutput);
            return batches.flatMap((Function1 & Serializable & scala.Serializable)batch -> {
                numInputBatches.$plus$eq(1L);
                numOutputRows.$plus$eq((long)batch.numRows());
                return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.rowIterator()).asScala()).map((Function1)toUnsafe);
            });
        };
        boolean x$2 = qual$1.mapPartitionsInternal$default$2();
        return qual$1.mapPartitionsInternal((Function1)x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
    }

    private Promise<Broadcast<Object>> promise$lzycompute() {
        CometColumnarToRowExec cometColumnarToRowExec = this;
        synchronized (cometColumnarToRowExec) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.promise = Promise$.MODULE$.apply();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.promise;
    }

    private Promise<Broadcast<Object>> promise() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.promise$lzycompute();
        }
        return this.promise;
    }

    private long timeout() {
        return this.timeout;
    }

    private UUID runId() {
        return this.runId;
    }

    private Option<CometBroadcastExchangeExec> cometBroadcastExchange$lzycompute() {
        CometColumnarToRowExec cometColumnarToRowExec = this;
        synchronized (cometColumnarToRowExec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cometBroadcastExchange = this.findCometBroadcastExchange(this.child());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.cometBroadcastExchange;
    }

    private Option<CometBroadcastExchangeExec> cometBroadcastExchange() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.cometBroadcastExchange$lzycompute();
        }
        return this.cometBroadcastExchange;
    }

    private Future<Broadcast<Object>> relationFuture$lzycompute() {
        CometColumnarToRowExec cometColumnarToRowExec = this;
        synchronized (cometColumnarToRowExec) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.relationFuture = SQLExecution$.MODULE$.withThreadLocalCaptured(this.session(), (ExecutorService)CometBroadcastExchangeExec$.MODULE$.executionContext(), (Function0 & Serializable & scala.Serializable)() -> {
                    Broadcast broadcast;
                    try {
                        this.sparkContext().setJobGroup(this.runId().toString(), new StringBuilder(46).append("CometColumnarToRow broadcast exchange (runId ").append(this.runId()).append(")").toString(), true);
                        SQLMetric numOutputRows = this.longMetric("numOutputRows");
                        SQLMetric numInputBatches = this.longMetric("numInputBatches");
                        Seq<Attribute> localOutput = this.output();
                        Broadcast broadcastColumnar = this.child().executeBroadcast();
                        ChunkedByteBuffer[] serializedBatches = (ChunkedByteBuffer[])broadcastColumnar.value();
                        UnsafeProjection toUnsafe = UnsafeProjection$.MODULE$.create(localOutput, localOutput);
                        Iterator rows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serializedBatches)).iterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Utils$.MODULE$.decodeBatches((ChunkedByteBuffer)x$1, this.getClass().getSimpleName())).flatMap((Function1 & Serializable & scala.Serializable)batch -> {
                            numInputBatches.$plus$eq(1L);
                            numOutputRows.$plus$eq((long)batch.numRows());
                            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.rowIterator()).asScala()).map((Function1)toUnsafe);
                        });
                        BroadcastMode mode = ((CometBroadcastExchangeExec)this.cometBroadcastExchange().get()).mode();
                        Object relation = mode.transform(rows, (Option)new Some((Object)BoxesRunTime.boxToLong((long)numOutputRows.value())));
                        Broadcast broadcasted = this.sparkContext().broadcastInternal(relation, true, ClassTag$.MODULE$.Any());
                        String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                        SQLMetrics$.MODULE$.postDriverMetricUpdates(this.sparkContext(), executionId, this.metrics().values().toSeq());
                        this.promise().trySuccess((Object)broadcasted);
                        broadcast = broadcasted;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof OutOfMemoryError) {
                            OutOfMemoryError outOfMemoryError = (OutOfMemoryError)throwable2;
                            SparkFatalException ex = new SparkFatalException((Throwable)outOfMemoryError);
                            this.promise().tryFailure((Throwable)ex);
                            throw ex;
                        }
                        if (!NonFatal$.MODULE$.apply(throwable2)) {
                            SparkFatalException ex = new SparkFatalException(throwable2);
                            this.promise().tryFailure((Throwable)ex);
                            throw ex;
                        }
                        if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            this.promise().tryFailure(throwable3);
                            throw throwable3;
                        }
                        throw throwable;
                    }
                    return broadcast;
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.relationFuture;
    }

    public Future<Broadcast<Object>> relationFuture() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.relationFuture$lzycompute();
        }
        return this.relationFuture;
    }

    public <T> Broadcast<T> doExecuteBroadcast() {
        Broadcast<Object> broadcast;
        if (this.cometBroadcastExchange().isEmpty()) {
            throw new SparkException(new StringBuilder(105).append("ColumnarToRowExec only supports doExecuteBroadcast when child contains a CometBroadcastExchange, but got ").append(this.child()).toString());
        }
        try {
            broadcast = this.relationFuture().get(this.timeout(), TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            Object object;
            this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not execute broadcast in ").append(this.timeout()).append(" secs.").toString(), ex);
            if (!this.relationFuture().isDone()) {
                this.sparkContext().cancelJobGroup(this.runId().toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.relationFuture().cancel(true));
            } else {
                object = BoxedUnit.UNIT;
            }
            throw QueryExecutionErrors$.MODULE$.executeBroadcastTimeoutError(this.timeout(), (Option)new Some((Object)ex));
        }
        return broadcast;
    }

    private Option<CometBroadcastExchangeExec> findCometBroadcastExchange(SparkPlan op2) {
        while (true) {
            SparkPlan sparkPlan;
            if ((sparkPlan = op2) instanceof CometBroadcastExchangeExec) {
                CometBroadcastExchangeExec cometBroadcastExchangeExec = (CometBroadcastExchangeExec)sparkPlan;
                return new Some((Object)cometBroadcastExchangeExec);
            }
            if (!(sparkPlan instanceof BroadcastQueryStageExec)) break;
            BroadcastQueryStageExec broadcastQueryStageExec = (BroadcastQueryStageExec)sparkPlan;
            op2 = broadcastQueryStageExec.plan();
        }
        return op2.children().collectFirst(Function$.MODULE$.unlift((Function1 & Serializable & scala.Serializable)op -> this.findCometBroadcastExchange((SparkPlan)op)));
    }

    private ExprCode genCodeColumnVector(CodegenContext ctx, String columnVar, String ordinal, DataType dataType, boolean nullable) {
        String javaType = CodeGenerator$.MODULE$.javaType(dataType);
        String value = CodeGenerator$.MODULE$.getValueFromVector(columnVar, dataType, ordinal);
        FalseLiteral$ isNullVar = nullable ? JavaCode$.MODULE$.isNullVariable(ctx.freshName("isNull")) : FalseLiteral$.MODULE$;
        String valueVar = ctx.freshName("value");
        String str = new StringBuilder(18).append("columnVector[").append(columnVar).append(", ").append(ordinal).append(", ").append(dataType.simpleString()).append("]").toString();
        Block code = Block.BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.registerComment((Function0 & Serializable & scala.Serializable)() -> str, ctx.registerComment$default$2(), ctx.registerComment$default$3())})).$plus(nullable ? Block.BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = ", ".isNullAt(", ");\n        ", " ", " = ", " ? ", " : (", ");\n      "}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{isNullVar, columnVar, ordinal, javaType, valueVar, isNullVar, CodeGenerator$.MODULE$.defaultValue(dataType, CodeGenerator$.MODULE$.defaultValue$default$2()), value})) : Block.BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " = ", ";"}))), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaType, valueVar, value})));
        return new ExprCode(code, (ExprValue)isNullVar, (ExprValue)JavaCode$.MODULE$.variable(valueVar, dataType));
    }

    public String doProduce(CodegenContext ctx) {
        String input = ctx.addMutableState("scala.collection.Iterator", "input", (Function1 & Serializable & scala.Serializable)v -> new StringBuilder(13).append((String)v).append(" = inputs[0];").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String numOutputRows = this.metricTerm(ctx, "numOutputRows");
        String numInputBatches = this.metricTerm(ctx, "numInputBatches");
        String columnarBatchClz = ColumnarBatch.class.getName();
        String batch = ctx.addMutableState(columnarBatchClz, "batch", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String idx = ctx.addMutableState("int", "batchIdx", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        Seq columnVectorClzs = (Seq)this.child().vectorTypes().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.fill(this.output().indices().size(), (Function0 & Serializable & scala.Serializable)() -> ColumnVector.class.getName()));
        Tuple2 tuple2 = ((GenericTraversableTemplate)((TraversableLike)columnVectorClzs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String columnVectorClz = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                String name = ctx.addMutableState(columnVectorClz, new StringBuilder(11).append("colInstance").append(i).toString(), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                return new Tuple2((Object)name, (Object)new StringBuilder(16).append(name).append(" = (").append(columnVectorClz).append(") ").append(batch).append(".column(").append(i).append(");").toString());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq colVars = (Seq)tuple2._1();
        Seq columnAssigns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)colVars, (Object)columnAssigns);
        Seq colVars2 = (Seq)tuple22._1();
        Seq columnAssigns2 = (Seq)tuple22._2();
        String nextBatch = ctx.freshName("nextBatch");
        String nextBatchFuncName = ctx.addNewFunction(nextBatch, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n         |private void ").append(nextBatch).append("() throws java.io.IOException {\n         |  if (").append(input).append(".hasNext()) {\n         |    ").append(batch).append(" = (").append(columnarBatchClz).append(")").append(input).append(".next();\n         |    ").append(numInputBatches).append(".add(1);\n         |    ").append(numOutputRows).append(".add(").append(batch).append(".numRows());\n         |    ").append(idx).append(" = 0;\n         |    ").append(columnAssigns2.mkString("", "\n", "\n")).append("\n         |  }\n         |}").toString())).stripMargin(), ctx.addNewFunction$default$3());
        ctx.currentVars_$eq(null);
        String rowidx = ctx.freshName("rowIdx");
        Seq columnsBatchInput = (Seq)((TraversableLike)this.output().zip((GenIterable)colVars2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                String colVar = (String)tuple2._2();
                return this.genCodeColumnVector(ctx, colVar, rowidx, attr.dataType(), attr.nullable());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        String localIdx = ctx.freshName("localIdx");
        String localEnd = ctx.freshName("localEnd");
        String numRows = ctx.freshName("numRows");
        String shouldStop = this.parent().needStopCheck() ? new StringBuilder(38).append("if (shouldStop()) { ").append(idx).append(" = ").append(rowidx).append(" + 1; return; }").toString() : "// shouldStop check is eliminated";
        String writableColumnVectorClz = WritableColumnVector.class.getName();
        String constantColumnVectorClz = ConstantColumnVector.class.getName();
        String cometPlainColumnVectorClz = CometPlainVector.class.getName();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(877).append("\n       |if (").append(batch).append(" == null) {\n       |  ").append(nextBatchFuncName).append("();\n       |}\n       |while (").append(this.limitNotReachedCond()).append(" ").append(batch).append(" != null) {\n       |  int ").append(numRows).append(" = ").append(batch).append(".numRows();\n       |  int ").append(localEnd).append(" = ").append(numRows).append(" - ").append(idx).append(";\n       |  for (int ").append(localIdx).append(" = 0; ").append(localIdx).append(" < ").append(localEnd).append("; ").append(localIdx).append("++) {\n       |    int ").append(rowidx).append(" = ").append(idx).append(" + ").append(localIdx).append(";\n       |    ").append(this.consume(ctx, (Seq<ExprCode>)columnsBatchInput, this.consume$default$3()).trim()).append("\n       |    ").append(shouldStop).append("\n       |  }\n       |  ").append(idx).append(" = ").append(numRows).append(";\n       |\n       |  // Comet fix for SPARK-50235\n       |  for (int i = 0; i < ").append(colVars2.length()).append("; i++) {\n       |    if (!(").append(batch).append(".column(i) instanceof ").append(writableColumnVectorClz).append(" || ").append(batch).append(".column(i) instanceof ").append(constantColumnVectorClz).append(" || ").append(batch).append(".column(i) instanceof ").append(cometPlainColumnVectorClz).append(")) {\n       |      ").append(batch).append(".column(i).close();\n       |    } else if (").append(batch).append(".column(i) instanceof ").append(cometPlainColumnVectorClz).append(") {\n       |      ").append(cometPlainColumnVectorClz).append(" cometPlainColumnVector = (").append(cometPlainColumnVectorClz).append(") ").append(batch).append(".column(i);\n       |      if (!cometPlainColumnVector.isReused()) {\n       |        cometPlainColumnVector.close();\n       |      }\n       |    }\n       |  }\n       |\n       |  ").append(batch).append(" = null;\n       |  ").append(nextBatchFuncName).append("();\n       |}\n       |// Comet fix for SPARK-50235: clean up resources\n       |if (").append(batch).append(" != null) {\n       |  ").append(batch).append(".close();\n       |}\n     ").toString())).stripMargin();
    }

    public Seq<RDD<InternalRow>> inputRDDs() {
        return (Seq)new .colon.colon((Object)this.child().executeColumnar(), (List)Nil$.MODULE$);
    }

    public CometColumnarToRowExec withNewChildInternal(SparkPlan newChild) {
        return this.copy(newChild);
    }

    public CometColumnarToRowExec copy(SparkPlan child) {
        return new CometColumnarToRowExec(child);
    }

    public SparkPlan copy$default$1() {
        return this.child();
    }

    public String productPrefix() {
        return "CometColumnarToRowExec";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CometColumnarToRowExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CometColumnarToRowExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        CometColumnarToRowExec cometColumnarToRowExec = (CometColumnarToRowExec)((Object)x$1);
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = cometColumnarToRowExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!sparkPlan.equals(sparkPlan2)) return false;
        if (!cometColumnarToRowExec.canEqual((Object)this)) return false;
        return true;
    }

    public CometColumnarToRowExec(SparkPlan child) {
        this.child = child;
        UnaryLike.$init$((UnaryLike)this);
        UnaryExecNode.$init$((UnaryExecNode)this);
        CodegenSupport.$init$((CodegenSupport)this);
        Predef$.MODULE$.assert(org.apache.spark.util.Utils$.MODULE$.isInRunningSparkTask() || child.supportsColumnar());
        this.timeout = this.conf().broadcastTimeout();
        this.runId = UUID.randomUUID();
    }
}

