/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import java.util.Arrays;
import org.apache.datasketches.hive.cpc.ObjectInspectorValidator;
import org.apache.datasketches.hive.cpc.SketchEvaluator;
import org.apache.datasketches.hive.cpc.SketchState;
import org.apache.datasketches.hive.cpc.State;
import org.apache.datasketches.hive.cpc.UnionState;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="dataToSketch", value="_FUNC_(expr, lgK, seed) - Compute a sketch on data 'expr' with given parameters lgK and target type", extended="Example:\n> SELECT dataToSketch(val, 12) FROM src;\nThe return value is a binary blob that can be operated on by other sketch related functions. The lgK parameter controls the sketch size and rlative error expected from the sketch. It is optional an must be from 4 to 26. The default is 11, which is expected to yield errors of roughly +-1.5% in the estimation of uniques with 95% confidence. The seed parameter is optional")
public class DataToSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length < 1) {
            throw new UDFArgumentException("Please specify at least 1 argument");
        }
        if (inspectors.length > 3) {
            throw new UDFArgumentException("Please specify no more than 3 arguments");
        }
        ObjectInspectorValidator.validateCategoryPrimitive(inspectors[0], 0);
        if (inspectors.length > 1) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[1], 1);
            if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)inspectors[1])) {
                throw new UDFArgumentTypeException(1, "The second argument must be a constant");
            }
        }
        if (inspectors.length > 2) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[2], 2);
            if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)inspectors[2])) {
                throw new UDFArgumentTypeException(2, "The third argument must be a constant");
            }
        }
        return new DataToSketchEvaluator();
    }

    public static class DataToSketchEvaluator
    extends SketchEvaluator {
        private GenericUDAFEvaluator.Mode mode_;

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            if (this.mode_ == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode_ == GenericUDAFEvaluator.Mode.COMPLETE) {
                return new SketchState();
            }
            return new UnionState();
        }

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            super.init(mode, parameters);
            this.mode_ = mode;
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputInspector_ = (PrimitiveObjectInspector)parameters[0];
                if (parameters.length > 1) {
                    this.lgKInspector_ = (PrimitiveObjectInspector)parameters[1];
                }
                if (parameters.length > 2) {
                    this.seedInspector_ = (PrimitiveObjectInspector)parameters[2];
                }
            } else {
                this.intermediateInspector_ = (StructObjectInspector)parameters[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("lgK", "seed", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            if (parameters[0] == null) {
                return;
            }
            SketchState state = (SketchState)agg;
            if (!state.isInitialized()) {
                this.initializeState(state, parameters);
            }
            state.update(parameters[0], this.inputInspector_);
        }

        private void initializeState(State state, Object[] parameters) {
            int lgK = 11;
            if (this.lgKInspector_ != null) {
                lgK = PrimitiveObjectInspectorUtils.getInt((Object)parameters[1], (PrimitiveObjectInspector)this.lgKInspector_);
            }
            long seed = 9001L;
            if (this.seedInspector_ != null) {
                seed = PrimitiveObjectInspectorUtils.getLong((Object)parameters[2], (PrimitiveObjectInspector)this.seedInspector_);
            }
            state.init(lgK, seed);
        }
    }
}

