/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class ExcludeSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable firstSketchBytes, BytesWritable secondSketchBytes, long hashSeed) {
        Sketch firstSketch = null;
        if (firstSketchBytes != null && firstSketchBytes.getLength() > 0) {
            firstSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(firstSketchBytes), (long)hashSeed);
        }
        Sketch secondSketch = null;
        if (secondSketchBytes != null && secondSketchBytes.getLength() > 0) {
            secondSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(secondSketchBytes), (long)hashSeed);
        }
        AnotB anotb = SetOperation.builder().setSeed(hashSeed).buildANotB();
        anotb.update(firstSketch, secondSketch);
        byte[] excludeSketchBytes = anotb.getResult().toByteArray();
        BytesWritable result = new BytesWritable();
        result.set(excludeSketchBytes, 0, excludeSketchBytes.length);
        return result;
    }

    public BytesWritable evaluate(BytesWritable firstSketchBytes, BytesWritable secondSketchBytes) {
        return this.evaluate(firstSketchBytes, secondSketchBytes, 9001L);
    }
}

