/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class IntersectSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable firstSketchBytes, BytesWritable secondSketchBytes, long hashSeed) {
        Sketch firstSketch = null;
        if (firstSketchBytes != null && firstSketchBytes.getLength() > 0) {
            firstSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(firstSketchBytes), (long)hashSeed);
        }
        Sketch secondSketch = null;
        if (secondSketchBytes != null && secondSketchBytes.getLength() > 0) {
            secondSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(secondSketchBytes), (long)hashSeed);
        }
        Intersection intersect = SetOperation.builder().setSeed(hashSeed).buildIntersection();
        intersect.update(firstSketch);
        intersect.update(secondSketch);
        return new BytesWritable(intersect.getResult().toByteArray());
    }

    public BytesWritable evaluate(BytesWritable firstSketchBytes, BytesWritable secondSketchBytes) {
        return this.evaluate(firstSketchBytes, secondSketchBytes, 9001L);
    }
}

