/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.ArrayOfDoublesSketches;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ArrayOfDoublesSketchToEstimates", value="_FUNC_(sketch)", extended="Returns a list of estimates from a given ArrayOfDoublesSketch. The result will be N+1 double values, where N is the number of double values kept in the sketch per key. The first estimate is the estimate of the number of unique keys in the original population. Next there are N estimates of the sums of the parameters in the original population (sums of the values in the sketch scaled to the original population)")
public class ArrayOfDoublesSketchToEstimatesUDF
extends UDF {
    public List<Double> evaluate(BytesWritable serializedSketch) {
        int i;
        if (serializedSketch == null) {
            return null;
        }
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        double[] sums = new double[sketch.getNumValues()];
        ArrayOfDoublesSketchIterator it = sketch.iterator();
        while (it.next()) {
            double[] values = it.getValues();
            for (i = 0; i < sketch.getNumValues(); ++i) {
                int n = i;
                sums[n] = sums[n] + values[i];
            }
        }
        ArrayList<Double> estimates = new ArrayList<Double>(sketch.getNumValues() + 1);
        estimates.add(sketch.getEstimate());
        for (i = 0; i < sums.length; ++i) {
            estimates.add(sums[i] / sketch.getTheta());
        }
        return estimates;
    }
}

