/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

public class UnionSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK, long seed) {
        CpcUnion union = new CpcUnion(lgK, seed);
        if (firstSketch != null) {
            union.update(CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(firstSketch), (long)seed));
        }
        if (secondSketch != null) {
            union.update(CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(secondSketch), (long)seed));
        }
        return new BytesWritable(union.getResult().toByteArray());
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch, int lgK) {
        return this.evaluate(firstSketch, secondSketch, lgK, 9001L);
    }

    public BytesWritable evaluate(BytesWritable firstSketch, BytesWritable secondSketch) {
        return this.evaluate(firstSketch, secondSketch, 11, 9001L);
    }
}

