/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetQuantile", value="_FUNC_(sketch, fraction)", extended=" Returns a quantile value from a given KllFloatsSketch. A single value for a given fraction is returned. The fraction represents a normalized rank, and must be from 0 to 1 inclusive. For example, a fraction of 0.5 corresponds to 50th percentile, which is the median value of the distribution (the number separating the higher half of the probability distribution from the lower half).")
public class GetQuantileUDF
extends UDF {
    public Float evaluate(BytesWritable serializedSketch, double fraction) {
        if (serializedSketch == null) {
            return null;
        }
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        return Float.valueOf(sketch.getQuantile(fraction));
    }
}

