/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.hll.AuxHashMap;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.IntMemoryPairIterator;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

class DirectAuxHashMap
implements AuxHashMap {
    private final DirectHllArray host;
    private final boolean readOnly;

    DirectAuxHashMap(DirectHllArray host, boolean initialize) {
        this.host = host;
        this.readOnly = host.wmem == null;
        int initLgArrInts = HllUtil.LG_AUX_ARR_INTS[host.lgConfigK];
        if (initialize) {
            if (this.readOnly) {
                HllUtil.noWriteAccess();
            }
            PreambleUtil.insertLgArr(host.wmem, initLgArrInts);
            host.wmem.clear((long)host.auxStart, (long)(4 << initLgArrInts));
        } else if (PreambleUtil.extractLgArr(host.mem) < initLgArrInts) {
            if (this.readOnly) {
                throw new SketchesArgumentException("Possible Memory image corruption, incorrect LgArr field in preamble.");
            }
            int lgArr = PreambleUtil.computeLgArr((Memory)host.wmem, host.auxHashMap.getAuxCount(), host.lgConfigK);
            PreambleUtil.insertLgArr(host.wmem, lgArr);
        }
    }

    @Override
    public DirectAuxHashMap copy() {
        return null;
    }

    @Override
    public int getAuxCount() {
        return PreambleUtil.extractAuxCount(this.host.mem);
    }

    @Override
    public int[] getAuxIntArr() {
        return null;
    }

    @Override
    public int getCompactSizeBytes() {
        return this.getAuxCount() << 2;
    }

    @Override
    public PairIterator getIterator() {
        return new IntMemoryPairIterator(this.host.mem, (long)this.host.auxStart, 1 << this.getLgAuxArrInts(), this.host.lgConfigK);
    }

    @Override
    public int getLgAuxArrInts() {
        return PreambleUtil.extractLgArr(this.host.mem);
    }

    @Override
    public int getUpdatableSizeBytes() {
        return 4 << this.getLgAuxArrInts();
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public boolean isOffHeap() {
        return this.host.isOffHeap();
    }

    @Override
    public void mustAdd(int slotNo, int value) {
        if (this.readOnly) {
            HllUtil.noWriteAccess();
        }
        int index = DirectAuxHashMap.find(this.host, slotNo);
        int pair = HllUtil.pair(slotNo, value);
        if (index >= 0) {
            String pairStr = HllUtil.pairString(pair);
            throw new SketchesStateException("Found a slotNo that should not be there: " + pairStr);
        }
        this.host.wmem.putInt((long)(this.host.auxStart + (~index << 2)), pair);
        int auxCount = PreambleUtil.extractAuxCount(this.host.mem);
        PreambleUtil.insertAuxCount(this.host.wmem, ++auxCount);
        int lgAuxArrInts = PreambleUtil.extractLgArr(this.host.mem);
        if (4 * auxCount > 3 * (1 << lgAuxArrInts)) {
            DirectAuxHashMap.grow(this.host, lgAuxArrInts);
        }
    }

    @Override
    public int mustFindValueFor(int slotNo) {
        int index = DirectAuxHashMap.find(this.host, slotNo);
        if (index >= 0) {
            int pair = this.host.mem.getInt((long)(this.host.auxStart + (index << 2)));
            return HllUtil.getPairValue(pair);
        }
        throw new SketchesStateException("SlotNo not found: " + slotNo);
    }

    @Override
    public void mustReplace(int slotNo, int value) {
        int index;
        if (this.readOnly) {
            HllUtil.noWriteAccess();
        }
        if ((index = DirectAuxHashMap.find(this.host, slotNo)) >= 0) {
            this.host.wmem.putInt((long)(this.host.auxStart + (index << 2)), HllUtil.pair(slotNo, value));
            return;
        }
        String pairStr = HllUtil.pairString(HllUtil.pair(slotNo, value));
        throw new SketchesStateException("Pair not found: " + pairStr);
    }

    private static final int find(DirectHllArray host, int slotNo) {
        int stride;
        int probe;
        int lgAuxArrInts = PreambleUtil.extractLgArr(host.mem);
        assert (lgAuxArrInts < host.lgConfigK) : lgAuxArrInts;
        int auxInts = 1 << lgAuxArrInts;
        int auxArrMask = auxInts - 1;
        int configKmask = (1 << host.lgConfigK) - 1;
        int loopIndex = probe = slotNo & auxArrMask;
        do {
            int arrVal;
            if ((arrVal = host.mem.getInt((long)(host.auxStart + (probe << 2)))) == 0) {
                return ~probe;
            }
            if (slotNo != (arrVal & configKmask)) continue;
            return probe;
        } while ((probe = probe + (stride = slotNo >>> lgAuxArrInts | 1) & auxArrMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    private static final void grow(DirectHllArray host, int oldLgAuxArrInts) {
        if (host.wmem == null) {
            HllUtil.noWriteAccess();
        }
        int oldAuxArrInts = 1 << oldLgAuxArrInts;
        int[] oldIntArray = new int[oldAuxArrInts];
        host.wmem.getIntArray((long)host.auxStart, oldIntArray, 0, oldAuxArrInts);
        PreambleUtil.insertLgArr(host.wmem, oldLgAuxArrInts + 1);
        long newAuxBytes = oldAuxArrInts << 3;
        long requestBytes = (long)host.auxStart + newAuxBytes;
        long oldCapBytes = host.wmem.getCapacity();
        if (requestBytes > oldCapBytes) {
            MemoryRequestServer svr = host.wmem.getMemoryRequestServer();
            WritableMemory newWmem = svr.request(requestBytes);
            host.wmem.copyTo(0L, newWmem, 0L, (long)host.auxStart);
            newWmem.clear((long)host.auxStart, newAuxBytes);
            svr.requestClose(host.wmem, newWmem);
            host.updateMemory(newWmem);
        }
        int configKmask = (1 << host.lgConfigK) - 1;
        for (int i = 0; i < oldAuxArrInts; ++i) {
            int fetched = oldIntArray[i];
            if (fetched == 0) continue;
            int index = DirectAuxHashMap.find(host, fetched & configKmask);
            host.wmem.putInt((long)(host.auxStart + (~index << 2)), fetched);
        }
    }
}

