/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsUpdateImpl;

final class ItemsUtil {
    static final int ITEMS_SER_VER = 3;
    static final int PRIOR_ITEMS_SER_VER = 2;

    private ItemsUtil() {
    }

    static void checkItemsSerVer(int serVer) {
        if (serVer == 3 || serVer == 2) {
            return;
        }
        throw new SketchesArgumentException("Possible corruption: Invalid Serialization Version: " + serVer);
    }

    static final <T> void validateValues(T[] values, Comparator<? super T> comparator) {
        int lenM1 = values.length - 1;
        for (int j = 0; j < lenM1; ++j) {
            if (values[j] != null && values[j + 1] != null && comparator.compare(values[j], values[j + 1]) < 0) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not null.");
        }
    }

    static <T> void processFullBaseBuffer(ItemsSketch<T> sketch) {
        int bbCount = sketch.getBaseBufferCount();
        long n = sketch.getN();
        assert (bbCount == 2 * sketch.getK());
        ItemsUpdateImpl.maybeGrowLevels(sketch, n);
        Object[] baseBuffer = sketch.getCombinedBuffer();
        Arrays.sort(baseBuffer, 0, bbCount, sketch.getComparator());
        ItemsUpdateImpl.inPlacePropagateCarry(0, null, 0, baseBuffer, 0, true, sketch);
        sketch.baseBufferCount_ = 0;
        Arrays.fill(baseBuffer, 0, 2 * sketch.getK(), null);
        assert (n / (2L * (long)sketch.getK()) == sketch.getBitPattern());
    }

    static <T> String toString(boolean sketchSummary, boolean dataDetail, ItemsSketch<T> sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        int bbCount = sketch.getBaseBufferCount();
        int combAllocCount = sketch.getCombinedBufferAllocatedCount();
        int k = sketch.getK();
        long bitPattern = sketch.getBitPattern();
        if (dataDetail) {
            sb.append(org.apache.datasketches.quantiles.Util.LS).append("### ").append(thisSimpleName).append(" DATA DETAIL: ").append(org.apache.datasketches.quantiles.Util.LS);
            Object[] items = sketch.getCombinedBuffer();
            sb.append("   BaseBuffer   :");
            if (bbCount > 0) {
                for (int i = 0; i < bbCount; ++i) {
                    sb.append(' ').append(items[i]);
                }
            }
            sb.append(org.apache.datasketches.quantiles.Util.LS);
            int numItems = combAllocCount;
            if (numItems > 2 * k) {
                sb.append("   Valid | Level");
                for (int j = 2 * k; j < numItems; ++j) {
                    if (j % k == 0) {
                        int levelNum = j > 2 * k ? (j - 2 * k) / k : 0;
                        String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                        String lvl = String.format("%5d", levelNum);
                        sb.append(org.apache.datasketches.quantiles.Util.LS).append("   ").append(validLvl).append(" ").append(lvl).append(":");
                    }
                    sb.append(' ').append(items[j]);
                }
                sb.append(org.apache.datasketches.quantiles.Util.LS);
            }
            sb.append("### END DATA DETAIL").append(org.apache.datasketches.quantiles.Util.LS);
        }
        if (sketchSummary) {
            long n = sketch.getN();
            String nStr = String.format("%,d", n);
            int numLevels = org.apache.datasketches.quantiles.Util.computeNumLevelsNeeded(k, n);
            String bufCntStr = String.format("%,d", combAllocCount);
            int preBytes = sketch.isEmpty() ? 8 : 16;
            double epsPmf = org.apache.datasketches.quantiles.Util.getNormalizedRankError(k, true);
            String epsPmfPctStr = String.format("%.3f%%", epsPmf * 100.0);
            double eps = org.apache.datasketches.quantiles.Util.getNormalizedRankError(k, false);
            String epsPctStr = String.format("%.3f%%", eps * 100.0);
            int numSamples = sketch.getRetainedItems();
            String numSampStr = String.format("%,d", numSamples);
            sb.append(org.apache.datasketches.quantiles.Util.LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   K                            : ").append(k).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   N                            : ").append(nStr).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   BaseBufferCount              : ").append(bbCount).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   CombinedBufferAllocatedCount : ").append(bufCntStr).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   Total Levels                 : ").append(numLevels).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   Valid Levels                 : ").append(org.apache.datasketches.quantiles.Util.computeValidLevels(bitPattern)).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   Valid Samples                : ").append(numSampStr).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   Preamble Bytes               : ").append(preBytes).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   Normalized Rank Error        : ").append(epsPctStr).append(Util.LS);
            sb.append("   Normalized Rank Error (PMF)  : ").append(epsPmfPctStr).append(Util.LS);
            sb.append("   Min Value                    : ").append(sketch.getMinValue()).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("   Max Value                    : ").append(sketch.getMaxValue()).append(org.apache.datasketches.quantiles.Util.LS);
            sb.append("### END SKETCH SUMMARY").append(org.apache.datasketches.quantiles.Util.LS);
        }
        return sb.toString();
    }
}

