/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.InequalitySearch;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqSketch;

class ReqAuxiliary {
    private static final String LS = System.getProperty("line.separator");
    private float[] items;
    private long[] weights;
    private final boolean hra;
    private final long N;

    ReqAuxiliary(ReqSketch sk) {
        this.hra = sk.getHighRankAccuracy();
        this.N = sk.getN();
        this.buildAuxTable(sk);
    }

    ReqAuxiliary(float[] items, long[] weights, boolean hra, long N) {
        this.hra = hra;
        this.N = N;
        this.items = items;
        this.weights = weights;
    }

    private void buildAuxTable(ReqSketch sk) {
        List<ReqCompactor> compactors = sk.getCompactors();
        int numComp = compactors.size();
        int totalItems = sk.getRetainedItems();
        this.items = new float[totalItems];
        this.weights = new long[totalItems];
        int auxCount = 0;
        for (int i = 0; i < numComp; ++i) {
            ReqCompactor c = compactors.get(i);
            FloatBuffer bufIn = c.getBuffer();
            long weight = 1 << c.getLgWeight();
            int bufInLen = bufIn.getCount();
            this.mergeSortIn(bufIn, weight, auxCount);
            auxCount += bufInLen;
        }
        this.createCumulativeWeights();
        this.dedup();
    }

    private void createCumulativeWeights() {
        int len = this.items.length;
        for (int i = 1; i < len; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] + this.weights[i - 1];
        }
        assert (this.weights[len - 1] == this.N);
    }

    void dedup() {
        int itemsLen = this.items.length;
        float[] itemsB = new float[itemsLen];
        long[] wtsB = new long[itemsLen];
        int bidx = 0;
        int i = 0;
        while (i < itemsLen) {
            int j;
            int hidup = j = i + 1;
            while (j < itemsLen && this.items[i] == this.items[j]) {
                hidup = j++;
            }
            if (j - i == 1) {
                itemsB[bidx] = this.items[i];
                wtsB[bidx++] = this.weights[i];
                ++i;
                continue;
            }
            itemsB[bidx] = this.items[hidup];
            wtsB[bidx++] = this.weights[hidup];
            i = j;
        }
        this.items = Arrays.copyOf(itemsB, bidx);
        this.weights = Arrays.copyOf(wtsB, bidx);
    }

    void mergeSortIn(FloatBuffer bufIn, long weight, int auxCount) {
        if (!bufIn.isSorted()) {
            bufIn.sort();
        }
        float[] arrIn = bufIn.getArray();
        int bufInLen = bufIn.getCount();
        int totLen = auxCount + bufInLen;
        int i = auxCount - 1;
        int j = bufInLen - 1;
        int h = this.hra ? bufIn.getCapacity() - 1 : bufInLen - 1;
        int k = totLen;
        while (k-- > 0) {
            if (i >= 0 && j >= 0) {
                if (this.items[i] >= arrIn[h]) {
                    this.items[k] = this.items[i];
                    this.weights[k] = this.weights[i--];
                    continue;
                }
                this.items[k] = arrIn[h--];
                --j;
                this.weights[k] = weight;
                continue;
            }
            if (i >= 0) {
                this.items[k] = this.items[i];
                this.weights[k] = this.weights[i--];
                continue;
            }
            if (j < 0) break;
            this.items[k] = arrIn[h--];
            --j;
            this.weights[k] = weight;
        }
    }

    float getQuantile(double normRank, boolean ltEq) {
        InequalitySearch crit;
        int index;
        int len = this.weights.length;
        long rank = (int)(normRank * (double)this.N);
        if (ltEq ? (index = InequalitySearch.find(this.weights, 0, len - 1, rank, crit = InequalitySearch.GE)) == -1 : (index = InequalitySearch.find(this.weights, 0, len - 1, rank, crit = InequalitySearch.GT)) == -1) {
            return this.items[len - 1];
        }
        return this.items[index];
    }

    Row getRow(int index) {
        return new Row(this.items[index], this.weights[index]);
    }

    String toString(int precision, int fieldSize) {
        StringBuilder sb = new StringBuilder();
        int p = precision;
        int z = fieldSize;
        String ff = "%" + z + "." + p + "f";
        String sf = "%" + z + "s";
        String df = "%" + z + "d";
        String dfmt = ff + df + LS;
        String sfmt = sf + sf + LS;
        sb.append("Aux Detail").append(LS);
        sb.append(String.format(sfmt, "Item", "Weight"));
        int totalCount = this.items.length;
        for (int i = 0; i < totalCount; ++i) {
            Row row = this.getRow(i);
            sb.append(String.format(dfmt, Float.valueOf(row.item), row.weight));
        }
        return sb.toString();
    }

    static class Row {
        float item;
        long weight;

        Row(float item, long weight) {
            this.item = item;
            this.weight = weight;
        }
    }
}

