/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSummary;
import org.apache.datasketches.tuple.Util;

public class UpdatableSketch<U, S extends UpdatableSummary<U>>
extends QuickSelectSketch<S> {
    public UpdatableSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory) {
        super(nomEntries, lgResizeFactor, samplingProbability, summaryFactory);
    }

    public UpdatableSketch(Memory srcMem, SummaryDeserializer<S> deserializer, SummaryFactory<S> summaryFactory) {
        super(srcMem, deserializer, summaryFactory);
    }

    public void update(long key, U value) {
        this.update(new long[]{key}, value);
    }

    public void update(double key, U value) {
        this.update(Util.doubleToLongArray(key), value);
    }

    public void update(String key, U value) {
        this.update(Util.stringToByteArray(key), value);
    }

    public void update(byte[] key, U value) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, 9001L)[0] >>> 1, value);
    }

    public void update(int[] key, U value) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, 9001L)[0] >>> 1, value);
    }

    public void update(long[] key, U value) {
        if (key == null || key.length == 0) {
            return;
        }
        this.insertOrIgnore(MurmurHash3.hash(key, 9001L)[0] >>> 1, value);
    }

    void insertOrIgnore(long hash, U value) {
        this.setEmpty(false);
        if (hash >= this.getThetaLong()) {
            return;
        }
        int index = this.findOrInsert(hash);
        if (index < 0) {
            this.insertSummary(index ^= 0xFFFFFFFF, this.getSummaryFactory().newSummary());
        }
        ((UpdatableSummary[])this.summaryTable_)[index].update(value);
        this.rebuildIfNeeded();
    }
}

