/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllFloatsSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void empty() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(Float.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)Double.isNaN(sketch.getRank(0.0f)));
        Assert.assertTrue((boolean)Float.isNaN(sketch.getMinValue()));
        Assert.assertTrue((boolean)Float.isNaN(sketch.getMaxValue()));
        Assert.assertTrue((boolean)Float.isNaN(sketch.getQuantile(0.5)));
        Assert.assertNull((Object)sketch.getQuantiles(new double[]{0.0}));
        Assert.assertNull((Object)sketch.getPMF(new float[]{0.0f}));
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneItem() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(1.0f), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0f), (double)1.0);
        Assert.assertEquals((float)sketch.getMinValue(), (float)1.0f);
        Assert.assertEquals((float)sketch.getMaxValue(), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.5), (float)1.0f);
    }

    @Test
    public void manyItemsEstimationMode() {
        int i;
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((float)i);
            Assert.assertEquals((long)sketch.getN(), (long)(i + 1));
        }
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((float)i), (double)trueRank, (double)0.013, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new float[]{500000.0f});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((float)sketch.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.0), (float)0.0f);
        Assert.assertEquals((float)sketch.getMaxValue(), (float)999999.0f);
        Assert.assertEquals((float)sketch.getQuantile(1.0), (float)999999.0f);
        double[] fractions = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            fractions[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = fractions[i2];
        }
        float[] quantiles = sketch.getQuantiles(fractions);
        float[] reverseQuantiles = sketch.getQuantiles(reverseFractions);
        float previousQuantile = 0.0f;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            float quantile = sketch.getQuantile(fractions[i3]);
            Assert.assertEquals((float)quantile, (float)quantiles[i3]);
            Assert.assertEquals((float)quantile, (float)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        int n = 1000;
        float[] values = new float[1000];
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance();
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i * 1.0f);
            sketch2.update((float)(20000 - i - 1) * 1.0f);
        }
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)9999.0f);
        Assert.assertEquals((float)sketch2.getMinValue(), (float)10000.0f);
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)19999.0f);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)130.0);
    }

    @Test
    public void mergeLowerK() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
            sketch2.update((float)(20000 - i - 1));
        }
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)9999.0f);
        Assert.assertEquals((float)sketch2.getMinValue(), (float)10000.0f);
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)19999.0f);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)250.0);
    }

    @Test
    public void mergeEmptyLowerK() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
    }

    @Test
    public void mergeExactModeLowerK() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        sketch2.update(1.0f);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance();
        sketch1.update(1.0f);
        sketch2.update(2.0f);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinValue(), (float)1.0f);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((float)i);
        }
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)10);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinValue(), (float)1.0f);
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)1000000.0f);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllFloatsSketch.newHeapInstance((int)7);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllFloatsSketch.newHeapInstance((int)65536);
    }

    @Test
    public void minK() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)8);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)175.0);
    }

    @Test
    public void maxK() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)65535);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)6.5);
    }

    @Test
    public void serializeDeserializeEmpty() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertTrue((boolean)Float.isNaN(sketch2.getMinValue()));
        Assert.assertTrue((boolean)Float.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void serializeDeserializeOneItem() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        sketch1.update(1.0f);
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertFalse((boolean)Float.isNaN(sketch2.getMinValue()));
        Assert.assertFalse((boolean)Float.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)12);
    }

    @Test
    public void deserializeOneItemV1() throws Exception {
        byte[] bytes = Util.getResourceBytes((String)"kll_sketch_float_one_item_v1.sk");
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
    }

    @Test
    public void serializeDeserialize() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((float)i);
        }
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((float)sketch2.getMinValue(), (float)sketch1.getMinValue());
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)sketch1.getMaxValue());
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(0.0f);
        sketch.getCDF(new float[]{1.0f, 0.0f});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(0.0f);
        sketch.getCDF(new float[]{Float.NaN});
    }

    @Test
    public void getQuantiles() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        float[] quantiles1 = sketch.getQuantiles(new double[]{0.0, 0.5, 1.0});
        float[] quantiles2 = sketch.getQuantiles(3);
        Assert.assertEquals((float[])quantiles1, (float[])quantiles2);
        Assert.assertEquals((float)quantiles1[0], (float)1.0f);
        Assert.assertEquals((float)quantiles1[1], (float)2.0f);
        Assert.assertEquals((float)quantiles1[2], (float)3.0f);
    }

    @Test
    public void checkReset() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n1 = sk.getN();
        float min1 = sk.getMinValue();
        float max1 = sk.getMaxValue();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n2 = sk.getN();
        float min2 = sk.getMinValue();
        float max2 = sk.getMaxValue();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((float)min2, (float)min1);
        Assert.assertEquals((float)max2, (float)max1);
    }

    @Test
    public void coverInheritanceArtifacts() {
        double[] dblArr = new double[]{};
        double dblV = 1.0;
        int idx = 1;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        try {
            sk.getDoubleItemsArray();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMaxDoubleValue();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinDoubleValue();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setDoubleItemsArray(dblArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setDoubleItemsArrayAt(idx, dblV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMaxDoubleValue(dblV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMinDoubleValue(dblV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkReadOnlyUpdate() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)mem);
        try {
            sk2.update(1.0f);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNewDirectInstanceAndSize() {
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        KllFloatsSketch.newDirectInstance((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        try {
            KllFloatsSketch.newDirectInstance(null, (MemoryRequestServer)memReqSvr);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            KllFloatsSketch.newDirectInstance((WritableMemory)wmem, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int updateSize = KllFloatsSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (boolean)true);
        int compactSize = KllFloatsSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (boolean)false);
        Assert.assertTrue((compactSize < updateSize ? 1 : 0) != 0);
    }

    @Test
    public void checkDeprecatedMethods() {
        int k = 200;
        int n = 200;
        int bytes = KllSketch.getMaxSerializedSizeBytes((int)200, (long)200L);
        Assert.assertEquals((int)bytes, (int)832);
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)200);
        for (int i = 1; i <= 200; ++i) {
            sk.update((float)i);
        }
        byte[] byteArr = sk.toByteArray();
        Assert.assertEquals((int)byteArr.length, (int)832);
        bytes = sk.getSerializedSizeBytes();
        Assert.assertEquals((int)bytes, (int)832);
    }
}

