/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MiscDirectDoublesTest {
    static final String LS = System.getProperty("line.separator");
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void checkBounds() {
        KllDoublesSketch sk = MiscDirectDoublesTest.getDDSketch(200, 0);
        for (int i = 0; i < 1000; ++i) {
            sk.update((double)i);
        }
        double eps = sk.getNormalizedRankError(false);
        double est = sk.getQuantile(0.5);
        double ub = sk.getQuantileUpperBound(0.5);
        double lb = sk.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)sk.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)sk.getQuantile(0.5 - eps));
        MiscDirectDoublesTest.println("Ext     : " + est);
        MiscDirectDoublesTest.println("UB      : " + ub);
        MiscDirectDoublesTest.println("LB      : " + lb);
    }

    @Test
    public void checkMisc() {
        KllDoublesSketch sk = MiscDirectDoublesTest.getDDSketch(8, 0);
        Assert.assertTrue((boolean)Objects.isNull(sk.getQuantiles(10)));
        for (int i = 0; i < 20; ++i) {
            sk.update((double)i);
        }
        double[] items = sk.getDoubleItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray();
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    public void visualCheckToString() {
        KllDoublesSketch sk = MiscDirectDoublesTest.getDDSketch(20, 0);
        for (int i = 0; i < 10; ++i) {
            sk.update((double)(i + 1));
        }
        MiscDirectDoublesTest.println(sk.toString(true, true));
        KllDoublesSketch sk2 = MiscDirectDoublesTest.getDDSketch(20, 0);
        for (int i = 0; i < 400; ++i) {
            sk2.update((double)(i + 1));
        }
        MiscDirectDoublesTest.println("\n" + sk2.toString(true, true));
        sk2.merge((KllSketch)sk);
        String s2 = sk2.toString(true, true);
        MiscDirectDoublesTest.println(LS + s2);
    }

    public void viewCompactions() {
        KllDoublesSketch sk = MiscDirectDoublesTest.getDDSketch(20, 0);
        MiscDirectDoublesTest.show(sk, 20);
        MiscDirectDoublesTest.show(sk, 21);
        MiscDirectDoublesTest.show(sk, 43);
        MiscDirectDoublesTest.show(sk, 44);
        MiscDirectDoublesTest.show(sk, 54);
        MiscDirectDoublesTest.show(sk, 55);
        MiscDirectDoublesTest.show(sk, 73);
        MiscDirectDoublesTest.show(sk, 74);
        MiscDirectDoublesTest.show(sk, 88);
        MiscDirectDoublesTest.show(sk, 89);
        MiscDirectDoublesTest.show(sk, 96);
        MiscDirectDoublesTest.show(sk, 97);
        MiscDirectDoublesTest.show(sk, 108);
    }

    private static void show(KllDoublesSketch sk, int limit) {
        for (int i = (int)sk.getN(); i < limit; ++i) {
            sk.update((double)(i + 1));
        }
        MiscDirectDoublesTest.println(sk.toString(true, true));
    }

    @Test
    public void checkSketchInitializeDoubleHeap() {
        int k = 20;
        KllDoublesSketch sk = MiscDirectDoublesTest.getDDSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)21.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = MiscDirectDoublesTest.getDDSketch(k, 0);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = MiscDirectDoublesTest.getDDSketch(k, 0);
        sk.update(1.0);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyCompactMem() {
        int k = 20;
        KllDoublesSketch sk2 = MiscDirectDoublesTest.getDDSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDoublesSketch sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)21.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = MiscDirectDoublesTest.getDDSketch(k, 0);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = MiscDirectDoublesTest.getDDSketch(k, 0);
        sk2.update(1.0);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyUpdatableMem() {
        int k = 20;
        KllDoublesSketch sk2 = MiscDirectDoublesTest.getDDSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllHeapDoublesSketch sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        MiscDirectDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)21.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = MiscDirectDoublesTest.getDDSketch(k, 0);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = MiscDirectDoublesTest.getDDSketch(k, 0);
        sk2.update(1.0);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringDoubleUpdatable() {
        int k = 20;
        MiscDirectDoublesTest.println("#### CASE: DOUBLE FULL UPDATABLE");
        KllDoublesSketch sk = MiscDirectDoublesTest.getDDSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        byte[] upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDirectDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDirectDoublesTest.println(s);
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        byte[] upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDirectDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        MiscDirectDoublesTest.println("#### CASE: DOUBLE EMPTY UPDATABLE");
        sk = MiscDirectDoublesTest.getDDSketch(k, 0);
        upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDirectDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDirectDoublesTest.println(s);
        sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDirectDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        MiscDirectDoublesTest.println("#### CASE: DOUBLE SINGLE UPDATABL");
        sk = MiscDirectDoublesTest.getDDSketch(k, 0);
        sk.update(1.0);
        upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDirectDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDirectDoublesTest.println(s);
        sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDirectDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 21;
        KllDoublesSketch sk1 = MiscDirectDoublesTest.getDDSketch(k, 0);
        KllDoublesSketch sk2 = MiscDirectDoublesTest.getDDSketch(k, 0);
        for (i = 1; i <= n1; ++i) {
            sk1.update((double)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((double)(i + 100));
        }
        MiscDirectDoublesTest.println(sk1.toString(true, true));
        MiscDirectDoublesTest.println(sk2.toString(true, true));
        sk1.merge((KllSketch)sk2);
        MiscDirectDoublesTest.println(sk1.toString(true, true));
        Assert.assertEquals((double)sk1.getMaxValue(), (double)121.0);
        Assert.assertEquals((double)sk1.getMinValue(), (double)1.0);
    }

    @Test
    public void checkSizes() {
        KllDoublesSketch sk = MiscDirectDoublesTest.getDDSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr1 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        int size1 = sk.getCurrentUpdatableSerializedSizeBytes();
        Assert.assertEquals((int)size1, (int)byteArr1.length);
        byte[] byteArr2 = sk.toByteArray();
        int size2 = sk.getCurrentCompactSerializedSizeBytes();
        Assert.assertEquals((int)size2, (int)byteArr2.length);
    }

    @Test
    public void checkNewInstance() {
        int k = 200;
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)k, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 10000; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((double)sk.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxValue(), (double)10000.0);
    }

    @Test
    public void checkDifferentM() {
        int k = 20;
        int m = 4;
        WritableMemory dstMem = WritableMemory.allocate((int)1000);
        KllDirectDoublesSketch sk = KllDirectDoublesSketch.newDirectInstance((int)k, (int)m, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 200; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((double)sk.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxValue(), (double)200.0);
    }

    private static KllDoublesSketch getDDSketch(int k, int n) {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllDoublesSketch ddsk = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return ddsk;
    }

    @Test
    public void printlnTest() {
        MiscDirectDoublesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

