/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.DirectWritableBufferImpl;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.NonNativeWritableBufferImpl;
import org.apache.datasketches.memory.StepBoolean;

final class DirectNonNativeWritableBufferImpl
extends NonNativeWritableBufferImpl {
    private static final int id = 104;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private MemoryRequestServer memReqSvr = null;
    private final byte typeId;

    DirectNonNativeWritableBufferImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid, MemoryRequestServer memReqSvr, BaseWritableMemoryImpl originMemory) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes, originMemory);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        assert (memReqSvr != null);
        this.memReqSvr = memReqSvr;
        this.typeId = (byte)(0x68 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return DirectNonNativeWritableBufferImpl.isNativeByteOrder(byteOrder) ? new DirectWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr, this.originMemory) : new DirectNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr, this.originMemory);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 4 | (readOnly ? 1 : 0);
        return DirectNonNativeWritableBufferImpl.isNativeByteOrder(byteOrder) ? new DirectWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr, this.originMemory) : new DirectNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr, this.originMemory);
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        this.assertValid();
        return this.memReqSvr;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

