/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseState;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Prim;
import org.apache.datasketches.memory.UnsafeUtil;
import org.apache.datasketches.memory.Util;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableDirectHandle;
import org.apache.datasketches.memory.WritableMapHandle;

public abstract class WritableMemory
extends Memory {
    WritableMemory(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
    }

    public static WritableMemory wrap(ByteBuffer byteBuf) {
        return BaseWritableMemoryImpl.wrapByteBuffer(byteBuf, false, byteBuf.order());
    }

    public static WritableMemory wrap(ByteBuffer byteBuf, ByteOrder byteOrder) {
        return BaseWritableMemoryImpl.wrapByteBuffer(byteBuf, false, byteOrder);
    }

    public static WritableMapHandle map(File file) throws IOException {
        return WritableMemory.map(file, 0L, file.length(), BaseState.nativeByteOrder);
    }

    public static WritableMapHandle map(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) throws IOException {
        Util.zeroCheck(capacityBytes, "Capacity");
        Util.nullCheck(file, "file is null");
        Util.negativeCheck(fileOffsetBytes, "File offset is negative");
        return BaseWritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, false, byteOrder);
    }

    public static WritableDirectHandle allocateDirect(long capacityBytes) {
        return WritableMemory.allocateDirect(capacityBytes, null);
    }

    public static WritableDirectHandle allocateDirect(long capacityBytes, MemoryRequestServer memReqSvr) {
        return BaseWritableMemoryImpl.wrapDirect(capacityBytes, BaseState.nativeByteOrder, memReqSvr);
    }

    public abstract WritableMemory writableRegion(long var1, long var3);

    public abstract WritableMemory writableRegion(long var1, long var3, ByteOrder var5);

    public abstract WritableBuffer asWritableBuffer();

    public abstract WritableBuffer asWritableBuffer(ByteOrder var1);

    public static WritableMemory allocate(int capacityBytes) {
        byte[] arr = new byte[capacityBytes];
        return WritableMemory.wrap(arr, BaseState.nativeByteOrder);
    }

    public static WritableMemory allocate(int capacityBytes, ByteOrder byteOrder) {
        byte[] arr = new byte[capacityBytes];
        return WritableMemory.wrap(arr, byteOrder);
    }

    public static WritableMemory wrap(boolean[] arr) {
        long lengthBytes = arr.length << (int)Prim.BOOLEAN.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, BaseState.nativeByteOrder);
    }

    public static WritableMemory wrap(byte[] arr) {
        return WritableMemory.wrap(arr, 0, arr.length, BaseState.nativeByteOrder);
    }

    public static WritableMemory wrap(byte[] arr, ByteOrder byteOrder) {
        return WritableMemory.wrap(arr, 0, arr.length, byteOrder);
    }

    public static WritableMemory wrap(byte[] arr, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, arr.length);
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, byteOrder);
    }

    public static WritableMemory wrap(char[] arr) {
        long lengthBytes = arr.length << (int)Prim.CHAR.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, BaseState.nativeByteOrder);
    }

    public static WritableMemory wrap(short[] arr) {
        long lengthBytes = arr.length << (int)Prim.SHORT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, BaseState.nativeByteOrder);
    }

    public static WritableMemory wrap(int[] arr) {
        long lengthBytes = arr.length << (int)Prim.INT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, BaseState.nativeByteOrder);
    }

    public static WritableMemory wrap(long[] arr) {
        long lengthBytes = arr.length << (int)Prim.LONG.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, BaseState.nativeByteOrder);
    }

    public static WritableMemory wrap(float[] arr) {
        long lengthBytes = arr.length << (int)Prim.FLOAT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, BaseState.nativeByteOrder);
    }

    public static WritableMemory wrap(double[] arr) {
        long lengthBytes = arr.length << (int)Prim.DOUBLE.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(arr, 0L, lengthBytes, false, BaseState.nativeByteOrder);
    }

    public abstract void putBoolean(long var1, boolean var3);

    public abstract void putBooleanArray(long var1, boolean[] var3, int var4, int var5);

    public abstract void putByte(long var1, byte var3);

    public abstract void putByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract void putChar(long var1, char var3);

    public abstract void putCharArray(long var1, char[] var3, int var4, int var5);

    public abstract long putCharsToUtf8(long var1, CharSequence var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public abstract void putFloat(long var1, float var3);

    public abstract void putFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract void putInt(long var1, int var3);

    public abstract void putIntArray(long var1, int[] var3, int var4, int var5);

    public abstract void putLong(long var1, long var3);

    public abstract void putLongArray(long var1, long[] var3, int var4, int var5);

    public abstract void putShort(long var1, short var3);

    public abstract void putShortArray(long var1, short[] var3, int var4, int var5);

    public abstract long getAndAddLong(long var1, long var3);

    public abstract boolean compareAndSwapLong(long var1, long var3, long var5);

    public abstract long getAndSetLong(long var1, long var3);

    public abstract Object getArray();

    public abstract void clear();

    public abstract void clear(long var1, long var3);

    public abstract void clearBits(long var1, byte var3);

    public abstract void fill(byte var1);

    public abstract void fill(long var1, long var3, byte var5);

    public abstract void setBits(long var1, byte var3);

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        return null;
    }
}

