/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.io.File;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.MapHandle;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.test.ReflectUtil;
import org.apache.datasketches.memory.test.UtilTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AllocateDirectMapMemoryTest {
    private static final String LS = System.getProperty("line.separator");
    MapHandle hand = null;

    @BeforeClass
    public void setReadOnly() {
        UtilTest.setGettysburgAddressFileToReadOnly();
    }

    @Test
    public void simpleMap() throws Exception {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Assert.assertTrue((boolean)ReflectUtil.isFileReadOnly(file));
        try (MapHandle rh = Memory.map((File)file);){
            rh.close();
        }
    }

    @Test
    public void testIllegalArguments() throws Exception {
        Throwable throwable;
        MapHandle rh2;
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try {
            rh2 = Memory.map((File)file, (long)-1L, (long)Integer.MAX_VALUE, (ByteOrder)ByteOrder.nativeOrder());
            throwable = null;
            try {
                Assert.fail((String)"Failed: testIllegalArgumentException: Position was negative.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rh2 != null) {
                    if (throwable != null) {
                        try {
                            rh2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rh2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException rh2) {
            // empty catch block
        }
        try {
            rh2 = Memory.map((File)file, (long)0L, (long)-1L, (ByteOrder)ByteOrder.nativeOrder());
            throwable = null;
            try {
                Assert.fail((String)"Failed: testIllegalArgumentException: Size was negative.");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rh2 != null) {
                    if (throwable != null) {
                        try {
                            rh2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rh2.close();
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMapAndMultipleClose() throws Exception {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (MapHandle rh = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            Memory map = rh.get();
            Assert.assertEquals((long)memCapacity, (long)map.getCapacity());
            rh.close();
            rh.close();
            map.getCapacity();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testReadFailAfterClose() throws Exception {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (MapHandle rh = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            Memory mmf = rh.get();
            rh.close();
            mmf.getByte(0L);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testLoad() throws Exception {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (MapHandle rh = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            rh.load();
            Assert.assertTrue((boolean)rh.isLoaded());
            rh.close();
        }
    }

    @Test
    public void testHandlerHandoffWithTWR() throws Exception {
        Memory mem;
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        try (MapHandle rh = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());){
            rh.load();
            Assert.assertTrue((boolean)rh.isLoaded());
            this.hand = rh;
            mem = rh.get();
        }
        Assert.assertFalse((boolean)mem.isValid());
    }

    @Test
    public void testHandoffWithoutClose() throws Exception {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        long memCapacity = file.length();
        MapHandle rh = Memory.map((File)file, (long)0L, (long)memCapacity, (ByteOrder)ByteOrder.nativeOrder());
        rh.load();
        Assert.assertTrue((boolean)rh.isLoaded());
        this.hand = rh;
    }

    @AfterClass
    public void afterAllTests() throws Exception {
        Memory mem;
        if (this.hand != null && (mem = this.hand.get()) != null && mem.isValid()) {
            this.hand.close();
            Assert.assertFalse((boolean)mem.isValid());
        }
    }

    @Test
    public void printlnTest() {
        AllocateDirectMapMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            AllocateDirectMapMemoryTest.print(LS);
        } else {
            AllocateDirectMapMemoryTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

