/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Buffer2Test {
    @Test
    public void testWrapByteBuf() {
        ByteBuffer bb = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(0);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb.asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        while (buffer.hasRemaining()) {
            Assert.assertEquals((byte)bb.get(), (byte)buffer.getByte());
        }
        Assert.assertEquals((boolean)true, (boolean)buffer.hasArray());
        Assert.assertEquals((boolean)true, (boolean)buffer.hasByteBuffer());
    }

    @Test
    public void testWrapDirectBB() {
        ByteBuffer bb = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(0);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb);
        while (buffer.hasRemaining()) {
            Assert.assertEquals((byte)bb.get(), (byte)buffer.getByte());
        }
        Assert.assertEquals((boolean)false, (boolean)buffer.hasArray());
        Assert.assertEquals((boolean)true, (boolean)buffer.hasByteBuffer());
    }

    @Test
    public void testWrapByteArray() {
        byte[] byteArray = new byte[64];
        for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            byteArray[i] = i;
        }
        Buffer buffer = Memory.wrap((byte[])byteArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((byte)byteArray[i++], (byte)buffer.getByte());
        }
        buffer.setPosition(0L);
        byte[] copyByteArray = new byte[64];
        buffer.getByteArray(copyByteArray, 0, 64);
        Assert.assertEquals((byte[])byteArray, (byte[])copyByteArray);
        Assert.assertEquals((boolean)true, (boolean)buffer.hasArray());
        Assert.assertEquals((boolean)false, (boolean)buffer.hasByteBuffer());
    }

    @Test
    public void testWrapCharArray() {
        char[] charArray = new char[64];
        for (int i = 0; i < 64; i = (int)((char)(i + 1))) {
            charArray[i] = i;
        }
        Buffer buffer = Memory.wrap((char[])charArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((char)charArray[i++], (char)buffer.getChar());
        }
        buffer.setPosition(0L);
        char[] copyCharArray = new char[64];
        buffer.getCharArray(copyCharArray, 0, 64);
        Assert.assertEquals((char[])charArray, (char[])copyCharArray);
    }

    @Test
    public void testWrapShortArray() {
        short[] shortArray = new short[64];
        for (int i = 0; i < 64; i = (int)((short)(i + 1))) {
            shortArray[i] = i;
        }
        Buffer buffer = Memory.wrap((short[])shortArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((short)shortArray[i++], (short)buffer.getShort());
        }
        buffer.setPosition(0L);
        short[] copyShortArray = new short[64];
        buffer.getShortArray(copyShortArray, 0, 64);
        Assert.assertEquals((short[])shortArray, (short[])copyShortArray);
    }

    @Test
    public void testWrapIntArray() {
        int[] intArray = new int[64];
        for (int i = 0; i < 64; ++i) {
            intArray[i] = i;
        }
        Buffer buffer = Memory.wrap((int[])intArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((int)intArray[i++], (int)buffer.getInt());
        }
        buffer.setPosition(0L);
        int[] copyIntArray = new int[64];
        buffer.getIntArray(copyIntArray, 0, 64);
        Assert.assertEquals((int[])intArray, (int[])copyIntArray);
    }

    @Test
    public void testWrapLongArray() {
        long[] longArray = new long[64];
        for (int i = 0; i < 64; ++i) {
            longArray[i] = i;
        }
        Buffer buffer = Memory.wrap((long[])longArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((long)longArray[i++], (long)buffer.getLong());
        }
        buffer.setPosition(0L);
        long[] copyLongArray = new long[64];
        buffer.getLongArray(copyLongArray, 0, 64);
        Assert.assertEquals((long[])longArray, (long[])copyLongArray);
    }

    @Test
    public void testWrapFloatArray() {
        float[] floatArray = new float[64];
        for (int i = 0; i < 64; ++i) {
            floatArray[i] = i;
        }
        Buffer buffer = Memory.wrap((float[])floatArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((float)floatArray[i++], (float)buffer.getFloat());
        }
        buffer.setPosition(0L);
        float[] copyFloatArray = new float[64];
        buffer.getFloatArray(copyFloatArray, 0, 64);
        Assert.assertEquals((float[])floatArray, (float[])copyFloatArray);
    }

    @Test
    public void testWrapDoubleArray() {
        double[] doubleArray = new double[64];
        for (int i = 0; i < 64; ++i) {
            doubleArray[i] = i;
        }
        Buffer buffer = Memory.wrap((double[])doubleArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((double)doubleArray[i++], (double)buffer.getDouble());
        }
        buffer.setPosition(0L);
        double[] copyDoubleArray = new double[64];
        buffer.getDoubleArray(copyDoubleArray, 0, 64);
        Assert.assertEquals((double[])doubleArray, (double[])copyDoubleArray);
    }

    @Test
    public void testWrapBooleanArray() {
        boolean[] booleanArray = new boolean[64];
        for (int i = 0; i < 64; ++i) {
            if (i % 3 != 0) continue;
            booleanArray[i] = true;
        }
        Buffer buffer = Memory.wrap((boolean[])booleanArray).asBuffer();
        int i = 0;
        while (buffer.hasRemaining()) {
            Assert.assertEquals((boolean)booleanArray[i++], (boolean)buffer.getBoolean());
        }
        buffer.setPosition(0L);
        boolean[] copyBooleanArray = new boolean[64];
        buffer.getBooleanArray(copyBooleanArray, 0, 64);
        for (int j = 0; j < copyBooleanArray.length; ++j) {
            Assert.assertEquals((boolean)booleanArray[j], (boolean)copyBooleanArray[j]);
        }
    }

    @Test
    public void testByteBufferPositionPreservation() {
        ByteBuffer bb = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(10);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb);
        while (buffer.hasRemaining()) {
            Assert.assertEquals((byte)bb.get(), (byte)buffer.getByte());
        }
    }

    @Test
    public void testGetAndHasRemaining() {
        ByteBuffer bb = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(10);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb);
        Assert.assertEquals((boolean)bb.hasRemaining(), (boolean)buffer.hasRemaining());
        Assert.assertEquals((long)bb.remaining(), (long)buffer.getRemaining());
    }

    @Test
    public void testGetSetIncResetPosition() {
        ByteBuffer bb = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(10);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb);
        Assert.assertEquals((long)bb.position(), (long)buffer.getPosition());
        Assert.assertEquals((long)30L, (long)buffer.setPosition(30L).getPosition());
        Assert.assertEquals((long)40L, (long)buffer.incrementPosition(10L).getPosition());
        Assert.assertEquals((long)0L, (long)buffer.resetPosition().getPosition());
    }

    @Test
    public void testByteBufferSlice() {
        ByteBuffer bb = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(10);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb.slice().order(ByteOrder.nativeOrder()));
        while (buffer.hasRemaining()) {
            Assert.assertEquals((byte)bb.get(), (byte)buffer.getByte());
        }
        Assert.assertEquals((long)bb.position(), (long)(buffer.getPosition() + 10L));
        Assert.assertEquals((long)30L, (long)buffer.setPosition(30L).getPosition());
        Assert.assertEquals((long)40L, (long)buffer.incrementPosition(10L).getPosition());
        Assert.assertEquals((long)0L, (long)buffer.resetPosition().getPosition());
    }

    @Test
    public void testDuplicateAndRegion() {
        ByteBuffer bb = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(10);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb.slice().order(ByteOrder.nativeOrder()));
        buffer.setPosition(30L);
        Buffer dupBuffer = buffer.duplicate();
        Buffer regionBuffer = buffer.region();
        Assert.assertEquals((long)dupBuffer.getStart(), (long)buffer.getStart());
        Assert.assertEquals((long)regionBuffer.getStart(), (long)buffer.getStart());
        Assert.assertEquals((long)dupBuffer.getEnd(), (long)buffer.getEnd());
        Assert.assertEquals((long)regionBuffer.getEnd(), (long)buffer.getRemaining());
        Assert.assertEquals((long)dupBuffer.getPosition(), (long)buffer.getPosition());
        Assert.assertEquals((long)regionBuffer.getPosition(), (long)0L);
        Assert.assertEquals((long)dupBuffer.getCapacity(), (long)buffer.getCapacity());
        Assert.assertEquals((long)regionBuffer.getCapacity(), (long)(buffer.getCapacity() - 30L));
    }

    @Test
    public void checkRORegions() {
        int n = 16;
        int n2 = n / 2;
        long[] arr = new long[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = i;
        }
        Memory mem = Memory.wrap((long[])arr);
        Buffer buf = mem.asBuffer();
        Buffer reg = buf.region((long)(n2 * 8), (long)(n2 * 8), buf.getTypeByteOrder());
        for (int i = 0; i < n2; ++i) {
            long v = reg.getLong((long)(i * 8));
            long e = i + n2;
            Assert.assertEquals((long)v, (long)e);
        }
    }

    @Test
    public void testAsMemory() {
        ByteBuffer bb = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder());
        Byte b = 0;
        while (bb.hasRemaining()) {
            bb.put(b);
            Byte by = b;
            Byte by2 = b = Byte.valueOf((byte)(b + 1));
        }
        bb.position(10);
        Buffer buffer = Buffer.wrap((ByteBuffer)bb);
        Memory memory = buffer.asMemory();
        Assert.assertEquals((long)buffer.getCapacity(), (long)memory.getCapacity());
        while (buffer.hasRemaining()) {
            Assert.assertEquals((byte)memory.getByte(buffer.getPosition()), (byte)buffer.getByte());
        }
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testROByteBuffer() {
        byte[] arr = new byte[64];
        ByteBuffer roBB = ByteBuffer.wrap(arr).asReadOnlyBuffer();
        Buffer buf = Buffer.wrap((ByteBuffer)roBB);
        WritableBuffer wbuf = (WritableBuffer)buf;
        wbuf.putByte(0L, (byte)1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testROByteBuffer2() {
        byte[] arr = new byte[64];
        ByteBuffer roBB = ByteBuffer.wrap(arr).asReadOnlyBuffer();
        Buffer buf = Buffer.wrap((ByteBuffer)roBB);
        WritableBuffer wbuf = (WritableBuffer)buf;
        wbuf.putByteArray(arr, 0, 64);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testIllegalFill() {
        byte[] arr = new byte[64];
        ByteBuffer roBB = ByteBuffer.wrap(arr).asReadOnlyBuffer();
        Buffer buf = Buffer.wrap((ByteBuffer)roBB);
        WritableBuffer wbuf = (WritableBuffer)buf;
        wbuf.fill((byte)0);
    }

    @Test
    public void checkWritableWrap() {
        ByteBuffer bb = ByteBuffer.allocate(16);
        WritableBuffer buf = WritableBuffer.writableWrap((ByteBuffer)bb, (ByteOrder)ByteOrder.nativeOrder(), null);
        Assert.assertNotNull((Object)buf);
        buf = WritableBuffer.writableWrap((ByteBuffer)bb, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());
        Assert.assertNotNull((Object)buf);
    }

    @Test
    public void testWritableDuplicate() {
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[1]);
        WritableBuffer wbuf = wmem.asWritableBuffer();
        WritableBuffer wbuf2 = wbuf.writableDuplicate();
        Assert.assertEquals((long)wbuf2.getCapacity(), (long)1L);
        Buffer buf = wmem.asBuffer();
        Assert.assertEquals((long)buf.getCapacity(), (long)1L);
    }

    @Test
    public void checkIndependence() {
        WritableBuffer wbuf2;
        int cap = 64;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        WritableBuffer wbuf1 = wmem.asWritableBuffer();
        Assert.assertFalse((wbuf1 == (wbuf2 = wmem.asWritableBuffer()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)wbuf1.isSameResource((Object)wbuf2));
        WritableMemory reg1 = wmem.writableRegion(0L, (long)cap);
        WritableMemory reg2 = wmem.writableRegion(0L, (long)cap);
        Assert.assertFalse((reg1 == reg2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)reg1.isSameResource((Object)reg2));
        WritableBuffer wbuf3 = wbuf1.writableRegion();
        WritableBuffer wbuf4 = wbuf1.writableRegion();
        Assert.assertFalse((wbuf3 == wbuf4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)wbuf3.isSameResource((Object)wbuf4));
    }

    @Test
    public void printlnTest() {
        Buffer2Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

