/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CopyMemoryTest {
    @Test
    public void heapWSource() {
        int k1 = 0x100000;
        int k2 = 2 * k1;
        WritableMemory srcMem = CopyMemoryTest.genMem(k1, false);
        WritableMemory dstMem = CopyMemoryTest.genMem(k2, true);
        srcMem.copyTo(0L, dstMem, (long)(k1 << 3), (long)(k1 << 3));
        CopyMemoryTest.check((Memory)dstMem, k1, k1, 1);
    }

    @Test
    public void heapROSource() {
        int k1 = 0x100000;
        int k2 = 2 * k1;
        WritableMemory srcMem = CopyMemoryTest.genMem(k1, false);
        WritableMemory dstMem = CopyMemoryTest.genMem(k2, true);
        srcMem.copyTo(0L, dstMem, (long)(k1 << 3), (long)(k1 << 3));
        CopyMemoryTest.check((Memory)dstMem, k1, k1, 1);
    }

    @Test
    public void directWSource() throws Exception {
        int k1 = 0x100000;
        int k2 = 2 * k1;
        try (WritableHandle wrh = CopyMemoryTest.genWRH(k1, false);){
            WritableMemory srcMem = wrh.getWritable();
            WritableMemory dstMem = CopyMemoryTest.genMem(k2, true);
            srcMem.copyTo(0L, dstMem, (long)(k1 << 3), (long)(k1 << 3));
            CopyMemoryTest.check((Memory)dstMem, k1, k1, 1);
        }
    }

    @Test
    public void directROSource() throws Exception {
        int k1 = 0x100000;
        int k2 = 2 * k1;
        try (WritableHandle wrh = CopyMemoryTest.genWRH(k1, false);){
            Memory srcMem = wrh.get();
            WritableMemory dstMem = CopyMemoryTest.genMem(k2, true);
            srcMem.copyTo(0L, dstMem, (long)(k1 << 3), (long)(k1 << 3));
            CopyMemoryTest.check((Memory)dstMem, k1, k1, 1);
        }
    }

    @Test
    public void heapWSrcRegion() {
        int k1 = 0x100000;
        WritableMemory baseMem = CopyMemoryTest.genMem(k1, false);
        WritableMemory srcReg = baseMem.writableRegion((long)(k1 / 2 << 3), (long)(k1 / 2 << 3));
        WritableMemory dstMem = CopyMemoryTest.genMem(2 * k1, true);
        srcReg.copyTo(0L, dstMem, (long)(k1 << 3), (long)(k1 / 2 << 3));
        CopyMemoryTest.check((Memory)dstMem, k1, k1 / 2, k1 / 2 + 1);
    }

    @Test
    public void heapROSrcRegion() {
        int k1 = 0x100000;
        WritableMemory baseMem = CopyMemoryTest.genMem(k1, false);
        Memory srcReg = baseMem.region((long)(k1 / 2 << 3), (long)(k1 / 2 << 3));
        WritableMemory dstMem = CopyMemoryTest.genMem(2 * k1, true);
        srcReg.copyTo(0L, dstMem, (long)(k1 << 3), (long)(k1 / 2 << 3));
        CopyMemoryTest.check((Memory)dstMem, k1, k1 / 2, k1 / 2 + 1);
    }

    @Test
    public void directROSrcRegion() throws Exception {
        int k1 = 0x100000;
        try (WritableHandle wrh = CopyMemoryTest.genWRH(k1, false);){
            Memory baseMem = wrh.get();
            Memory srcReg = baseMem.region((long)(k1 / 2 << 3), (long)(k1 / 2 << 3));
            WritableMemory dstMem = CopyMemoryTest.genMem(2 * k1, true);
            srcReg.copyTo(0L, dstMem, (long)(k1 << 3), (long)(k1 / 2 << 3));
            CopyMemoryTest.check((Memory)dstMem, k1, k1 / 2, k1 / 2 + 1);
        }
    }

    @Test
    public void testOverlappingCopyLeftToRight() {
        byte[] bytes = new byte[2621441];
        ThreadLocalRandom.current().nextBytes(bytes);
        byte[] referenceBytes = (byte[])bytes.clone();
        Memory referenceMem = Memory.wrap((byte[])referenceBytes);
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytes);
        long copyLen = 0x200000L;
        mem.copyTo(0L, mem, 524288L, copyLen);
        Assert.assertEquals((int)0, (int)mem.compareTo(524288L, copyLen, referenceMem, 0L, copyLen));
    }

    @Test
    public void testOverlappingCopyRightToLeft() {
        byte[] bytes = new byte[2621441];
        ThreadLocalRandom.current().nextBytes(bytes);
        byte[] referenceBytes = (byte[])bytes.clone();
        Memory referenceMem = Memory.wrap((byte[])referenceBytes);
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytes);
        long copyLen = 0x200000L;
        mem.copyTo(524288L, mem, 0L, copyLen);
        Assert.assertEquals((int)0, (int)mem.compareTo(0L, copyLen, referenceMem, 524288L, copyLen));
    }

    private static void check(Memory mem, int offsetLongs, int lengthLongs, int startValue) {
        int offBytes = offsetLongs << 3;
        for (long i = 0L; i < (long)lengthLongs; ++i) {
            Assert.assertEquals((long)mem.getLong((long)offBytes + (i << 3)), (long)(i + (long)startValue));
        }
    }

    private static WritableHandle genWRH(int longs, boolean empty) {
        WritableHandle wrh = WritableMemory.allocateDirect((long)(longs << 3));
        WritableMemory mem = wrh.getWritable();
        if (empty) {
            mem.clear();
        } else {
            for (int i = 0; i < longs; ++i) {
                mem.putLong((long)(i << 3), (long)(i + 1));
            }
        }
        return wrh;
    }

    private static WritableMemory genMem(int longs, boolean empty) {
        WritableMemory mem = WritableMemory.allocate((int)(longs << 3));
        if (!empty) {
            for (int i = 0; i < longs; ++i) {
                mem.putLong((long)(i << 3), (long)(i + 1));
            }
        }
        return mem;
    }

    @Test
    public void printlnTest() {
        CopyMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

