/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.datasketches.memory.internal.MemoryCleaner;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MemoryCleanerTest {
    @Test
    public void cleanerDeallocates() {
        SimpleDeallocator deallocator = new SimpleDeallocator();
        MemoryCleaner cleaner = new MemoryCleaner((Object)this, (Runnable)deallocator);
        cleaner.clean();
        Assert.assertTrue((boolean)SimpleDeallocator.getHasRun());
    }

    @Test
    public void noDeallocation() {
        SimpleDeallocator deallocator = new SimpleDeallocator();
        new MemoryCleaner((Object)this, (Runnable)deallocator);
        Assert.assertFalse((boolean)SimpleDeallocator.getHasRun());
    }

    static final class SimpleDeallocator
    implements Runnable {
        static final AtomicBoolean hasRun = new AtomicBoolean();

        SimpleDeallocator() {
            hasRun.set(false);
        }

        @Override
        public void run() {
            hasRun.compareAndSet(false, true);
        }

        public static Boolean getHasRun() {
            return hasRun.get();
        }
    }
}

