/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import org.apache.datasketches.memory.test.ReflectUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NioBitsTest {
    @Test
    public void checkVMParams() {
        NioBitsTest.println("Max MemoryImpl: " + ReflectUtil.getMaxDirectByteBufferMemory());
        NioBitsTest.println("Page Aligned: " + ReflectUtil.isPageAligned());
        NioBitsTest.println("Page Size: " + ReflectUtil.pageSize());
    }

    @Test
    public void checkGetAtomicFields() {
        long cap = 1024L;
        NioBitsTest.printStats();
        ReflectUtil.reserveMemory(cap, cap);
        NioBitsTest.printStats();
        ReflectUtil.unreserveMemory(cap, cap);
        NioBitsTest.printStats();
    }

    @Test
    public void checkPageCount() {
        Assert.assertEquals((int)ReflectUtil.pageCount(0L), (int)0);
        Assert.assertEquals((int)ReflectUtil.pageCount(1L), (int)1);
    }

    private static void printStats() {
        long count = ReflectUtil.getDirectAllocationsCount();
        long resMem = ReflectUtil.getReservedMemory();
        long totCap = ReflectUtil.getTotalCapacity();
        long maxDBBmem = ReflectUtil.getMaxDirectByteBufferMemory();
        String s = String.format("%,10d\t%,15d\t%,15d\t%,15d", count, resMem, totCap, maxDBBmem);
        NioBitsTest.println(s);
    }

    @Test
    public void printlnTest() {
        NioBitsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

